/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Color;
import java.awt.Graphics2D;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.content.ColorItem;
import org.apache.pivot.wtk.content.ListItem;
import org.apache.pivot.wtk.content.ListViewItemRenderer;
import org.apache.pivot.wtk.media.Image;

public class ListViewColorItemRenderer
extends ListViewItemRenderer {
    private ColorBadge colorBadge = new ColorBadge();
    private ListItem listItem = new ListItem(this.colorBadge);

    public ListViewColorItemRenderer() {
        this.setShowIcon(true);
    }

    public void render(Object item, int index, ListView listView, boolean selected, boolean checked, boolean highlighted, boolean disabled) {
        if (item != null) {
            ColorItem colorItem = item == null ? new ColorItem(Color.WHITE) : (item instanceof ColorItem ? (ColorItem)item : (item instanceof Color ? new ColorItem((Color)item) : new ColorItem(GraphicsUtilities.decodeColor(item.toString()))));
            Color color = colorItem.getColor();
            String name = colorItem.getName();
            this.colorBadge.setColor(listView.isEnabled() ? color : new Color(color.getRed(), color.getGreen(), color.getBlue(), 153));
            this.listItem.setText(name);
        }
        super.render(this.listItem, index, listView, selected, checked, highlighted, disabled);
    }

    public static class ColorBadge
    extends Image {
        private Color color = Color.BLACK;
        public static final int SIZE = 14;

        public int getWidth() {
            return 14;
        }

        public int getHeight() {
            return 14;
        }

        public int getBaseline() {
            return 12;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void paint(Graphics2D graphics) {
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, 14, 14);
            graphics.setColor(this.color);
            graphics.fillRect(2, 2, 10, 10);
            graphics.setColor(Color.GRAY);
            GraphicsUtilities.drawRect(graphics, 0, 0, 14, 14);
        }
    }
}

