/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericSpinnerData
implements List<Integer> {
    private int lowerBound;
    private int upperBound;
    private int increment;
    private List.ListListenerList<Integer> listListeners = new List.ListListenerList();

    public NumericSpinnerData() {
        this(Short.MIN_VALUE, Short.MAX_VALUE, 1);
    }

    public NumericSpinnerData(int lowerBound, int upperBound) {
        this(lowerBound, upperBound, 1);
    }

    public NumericSpinnerData(int lowerBound, int upperBound, int increment) {
        if (lowerBound >= upperBound) {
            throw new IllegalArgumentException("Lower bound must be less than upper bound.");
        }
        long length = ((long)upperBound - (long)lowerBound) / (long)increment + 1L;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Bounded range is too large.");
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.increment = increment;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(int lowerBound) {
        this.lowerBound = lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(int upperBound) {
        this.upperBound = upperBound;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public int add(Integer item) {
        throw new UnsupportedOperationException();
    }

    public void insert(Integer item, int index) {
        throw new UnsupportedOperationException();
    }

    public Integer update(int index, Integer item) {
        throw new UnsupportedOperationException();
    }

    public int remove(Integer item) {
        throw new UnsupportedOperationException();
    }

    public Sequence<Integer> remove(int index, int count) {
        throw new UnsupportedOperationException();
    }

    public Integer get(int index) {
        if (index < 0 || index >= this.getLength()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index);
        }
        return this.lowerBound + index * this.increment;
    }

    public int indexOf(Integer item) {
        int distance;
        int index = -1;
        if (item >= this.lowerBound && item <= this.upperBound && (distance = item - this.lowerBound) % this.increment == 0) {
            index = distance / this.increment;
        }
        return index;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return this.getLength() == 0;
    }

    public int getLength() {
        return (this.upperBound - this.lowerBound) / this.increment + 1;
    }

    public Comparator<Integer> getComparator() {
        return null;
    }

    public void setComparator(Comparator<Integer> comparator) {
        throw new UnsupportedOperationException();
    }

    public Iterator<Integer> iterator() {
        return new DataIterator();
    }

    public ListenerList<ListListener<Integer>> getListListeners() {
        return this.listListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataIterator
    implements Iterator<Integer> {
        private int lowerBound;
        private int upperBound;
        private int increment;
        private int value;

        private DataIterator() {
            this.lowerBound = NumericSpinnerData.this.lowerBound;
            this.upperBound = NumericSpinnerData.this.upperBound;
            this.increment = NumericSpinnerData.this.increment;
            this.value = this.lowerBound;
        }

        @Override
        public boolean hasNext() {
            return this.value <= this.upperBound;
        }

        @Override
        public Integer next() {
            if (this.lowerBound != NumericSpinnerData.this.lowerBound || this.upperBound != NumericSpinnerData.this.upperBound || this.increment != NumericSpinnerData.this.increment) {
                throw new ConcurrentModificationException();
            }
            if (this.value > this.upperBound) {
                throw new NoSuchElementException();
            }
            int next = this.value;
            this.value += this.increment;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

