/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import org.apache.pivot.beans.BeanAdapter;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Checkbox;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.VerticalAlignment;

public class TableViewBooleanCellRenderer
extends BoxPane
implements TableView.CellRenderer {
    private Checkbox checkbox = new Checkbox();
    private boolean checkboxDisabled = false;

    public TableViewBooleanCellRenderer() {
        this.add(this.checkbox);
        this.getStyles().put("padding", (Object)3);
        this.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.CENTER);
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }

    public void render(Object row, int rowIndex, int columnIndex, TableView tableView, String columnName, boolean selected, boolean highlighted, boolean disabled) {
        if (row != null) {
            boolean checkboxSelected = false;
            if (columnName != null) {
                Object rowData = row instanceof Dictionary ? (Dictionary)row : new BeanAdapter(row);
                Object cellData = rowData.get((Object)columnName);
                if (cellData instanceof String) {
                    cellData = Boolean.parseBoolean((String)cellData);
                }
                if (cellData instanceof Boolean) {
                    checkboxSelected = (Boolean)cellData;
                } else {
                    System.err.println("Data for \"" + columnName + "\" is not an instance of " + Boolean.class.getName());
                }
            }
            this.checkbox.setSelected(checkboxSelected);
            this.checkbox.setEnabled(!this.checkboxDisabled && tableView.isEnabled() && !disabled);
        }
    }

    public String toString(Object row, String columnName) {
        return null;
    }

    public boolean isCheckboxDisabled() {
        return this.checkboxDisabled;
    }

    public void setCheckboxDisabled(boolean checkboxDisabled) {
        this.checkboxDisabled = checkboxDisabled;
    }
}

