/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Color;
import java.awt.Font;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.json.JSON;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.VerticalAlignment;

public class TableViewCellRenderer
extends Label
implements TableView.CellRenderer {
    public TableViewCellRenderer() {
        this.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.getStyles().put("padding", (Object)new Insets(2));
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }

    public void render(Object row, int rowIndex, int columnIndex, TableView tableView, String columnName, boolean selected, boolean highlighted, boolean disabled) {
        this.renderStyles(tableView, selected, disabled);
        String text = null;
        if (row != null && columnName != null) {
            text = this.toString(row, columnName);
        }
        this.setText(text);
    }

    protected void renderStyles(TableView tableView, boolean rowSelected, boolean rowDisabled) {
        Component.StyleDictionary tableViewStyles = tableView.getStyles();
        Dictionary styles = this.getStyles();
        Font font = (Font)tableViewStyles.get("font");
        styles.put("font", (Object)font);
        Color color = tableView.isEnabled() && !rowDisabled ? (rowSelected ? (tableView.isFocused() ? (Color)tableViewStyles.get("selectionColor") : (Color)tableViewStyles.get("inactiveSelectionColor")) : (Color)tableViewStyles.get("color")) : (Color)tableViewStyles.get("disabledColor");
        styles.put("color", (Object)color);
    }

    public String toString(Object row, String columnName) {
        Object cellData = JSON.get((Object)row, (String)columnName);
        return cellData == null ? null : cellData.toString();
    }
}

