/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import org.apache.pivot.json.JSON;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.media.Image;

public class TableViewImageCellRenderer
extends ImageView
implements TableView.CellRenderer {
    public static int DEFAULT_HEIGHT = 16;

    public TableViewImageCellRenderer() {
        this.setPreferredHeight(DEFAULT_HEIGHT);
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }

    public void setPreferredHeight(int preferredHeight) {
        if (preferredHeight == -1) {
            throw new IllegalArgumentException("Preferred height must be a fixed value.");
        }
        super.setPreferredHeight(preferredHeight);
    }

    public void setPreferredSize(int preferredWidth, int preferredHeight) {
        if (preferredHeight == -1) {
            throw new IllegalArgumentException("Preferred height must be a fixed value.");
        }
        super.setPreferredSize(preferredWidth, preferredHeight);
    }

    public void render(Object row, int rowIndex, int columnIndex, TableView tableView, String columnName, boolean selected, boolean highlighted, boolean disabled) {
        if (row != null) {
            Image image = null;
            if (columnName != null) {
                Object cellData = JSON.get((Object)row, (String)columnName);
                if (cellData == null || cellData instanceof Image) {
                    image = (Image)cellData;
                } else {
                    System.err.println("Data for \"" + columnName + "\" is not an instance of " + Image.class.getName());
                }
            }
            this.setImage(image);
        }
    }

    public String toString(Object row, String columnName) {
        return null;
    }
}

