/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects.easing;

import org.apache.pivot.wtk.effects.easing.Easing;

public class Exponential
implements Easing {
    public float easeIn(float time, float begin, float change, float duration) {
        return time == 0.0f ? begin : change * (float)Math.pow(2.0, 10.0f * (time / duration - 1.0f)) + begin;
    }

    public float easeOut(float time, float begin, float change, float duration) {
        return time == duration ? begin + change : change * ((float)(-Math.pow(2.0, -10.0f * time / duration)) + 1.0f) + begin;
    }

    public float easeInOut(float time, float begin, float change, float duration) {
        float f;
        if (time == 0.0f) {
            return begin;
        }
        if (time == duration) {
            return begin + change;
        }
        time /= duration / 2.0f;
        if (f < 1.0f) {
            return change / 2.0f * (float)Math.pow(2.0, 10.0f * (time - 1.0f)) + begin;
        }
        return change / 2.0f * ((float)(-Math.pow(2.0, -10.0f * (time - 1.0f))) + 2.0f) + begin;
    }
}

