/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.media;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import org.apache.pivot.wtk.media.Image;

public class Picture
extends Image {
    private BufferedImage bufferedImage = null;
    private int baseline = -1;

    public Picture(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("bufferedImage is null.");
        }
        this.bufferedImage = bufferedImage;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public int getWidth() {
        return this.bufferedImage.getWidth();
    }

    public int getHeight() {
        return this.bufferedImage.getHeight();
    }

    public void resample(int size) {
        this.resample(size, Interpolation.NEAREST_NEIGHBOR);
    }

    public void resample(int size, Interpolation interpolation) {
        int height;
        int width = this.getWidth();
        float aspectRatio = (float)width / (float)(height = this.getHeight());
        if (aspectRatio > 1.0f) {
            width = size;
            height = (int)((float)size / aspectRatio);
        } else {
            width = (int)((float)size * aspectRatio);
            height = size;
        }
        this.resample(width, height, interpolation);
    }

    public void resample(int width, int height) {
        this.resample(width, height, Interpolation.NEAREST_NEIGHBOR);
    }

    public void resample(int width, int height, Interpolation interpolation) {
        if (interpolation == null) {
            throw new IllegalArgumentException("interpolation is null.");
        }
        int previousWidth = this.getWidth();
        int previousHeight = this.getHeight();
        if (previousWidth != width || previousHeight != height) {
            int type = this.bufferedImage.getType();
            float scaleX = (float)width / (float)previousWidth;
            float scaleY = (float)height / (float)previousHeight;
            BufferedImage bufferedImage = new BufferedImage(width, height, type);
            Graphics2D bufferedImageGraphics = (Graphics2D)bufferedImage.getGraphics();
            if (this.bufferedImage.getTransparency() != 1) {
                bufferedImageGraphics.setComposite(AlphaComposite.Clear);
                bufferedImageGraphics.fillRect(0, 0, width, height);
                bufferedImageGraphics.setComposite(AlphaComposite.SrcOver);
            }
            Object interpolationHint = 0;
            switch (interpolation) {
                case NEAREST_NEIGHBOR: {
                    interpolationHint = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                    break;
                }
                case BILINEAR: {
                    interpolationHint = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
                    break;
                }
                case BICUBIC: {
                    interpolationHint = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
                }
            }
            bufferedImageGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolationHint);
            bufferedImageGraphics.scale(scaleX, scaleY);
            this.paint(bufferedImageGraphics);
            bufferedImageGraphics.dispose();
            this.bufferedImage = bufferedImage;
            this.imageListeners.sizeChanged(this, previousWidth, previousHeight);
        }
    }

    public int getBaseline() {
        return this.baseline;
    }

    public void setBaseline(int baseline) {
        int previousBaseline = this.baseline;
        if (baseline != previousBaseline) {
            this.baseline = baseline;
            this.imageListeners.baselineChanged(this, previousBaseline);
        }
    }

    public void paint(Graphics2D graphics) {
        graphics.drawImage((java.awt.Image)this.bufferedImage, 0, 0, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Interpolation {
        NEAREST_NEIGHBOR,
        BILINEAR,
        BICUBIC;

    }
}

