/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.util.Locale;
import org.apache.pivot.util.CalendarDate;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Calendar;
import org.apache.pivot.wtk.CalendarButton;
import org.apache.pivot.wtk.CalendarButtonListener;
import org.apache.pivot.wtk.CalendarButtonSelectionListener;
import org.apache.pivot.wtk.CalendarListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.FocusTraversalDirection;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.skin.ButtonSkin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CalendarButtonSkin
extends ButtonSkin
implements CalendarButton.Skin,
CalendarButtonListener,
CalendarButtonSelectionListener {
    protected Calendar calendar;
    protected Window calendarPopup;
    protected boolean pressed = false;
    private ComponentMouseButtonListener calendarPopupMouseButtonListener = new ComponentMouseButtonListener.Adapter(){

        public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
            CalendarButton calendarButton = (CalendarButton)CalendarButtonSkin.this.getComponent();
            CalendarButtonSkin.this.calendarPopup.close();
            CalendarDate date = CalendarButtonSkin.this.calendar.getSelectedDate();
            calendarButton.setSelectedDate(date);
            return true;
        }
    };
    private ComponentKeyListener calendarPopupKeyListener = new ComponentKeyListener.Adapter(){

        public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
            CalendarButton calendarButton = (CalendarButton)CalendarButtonSkin.this.getComponent();
            switch (keyCode) {
                case 27: {
                    CalendarButtonSkin.this.calendarPopup.close();
                    break;
                }
                case 9: 
                case 10: {
                    CalendarButtonSkin.this.calendarPopup.close();
                    if (keyCode == 9) {
                        FocusTraversalDirection direction = Keyboard.isPressed(Keyboard.Modifier.SHIFT) ? FocusTraversalDirection.BACKWARD : FocusTraversalDirection.FORWARD;
                        calendarButton.transferFocus(direction);
                    }
                    CalendarDate date = CalendarButtonSkin.this.calendar.getSelectedDate();
                    calendarButton.setSelectedDate(date);
                    break;
                }
            }
            return false;
        }
    };
    private WindowStateListener calendarPopupWindowStateListener = new WindowStateListener(){

        public void windowOpened(Window window) {
            Display display = window.getDisplay();
            display.getContainerMouseListeners().add((Object)CalendarButtonSkin.this.displayMouseListener);
            window.requestFocus();
        }

        public Vote previewWindowClose(Window window) {
            if (window.containsFocus()) {
                CalendarButtonSkin.this.getComponent().requestFocus();
            }
            return Vote.APPROVE;
        }

        public void windowCloseVetoed(Window window, Vote reason) {
            if (reason == Vote.DENY) {
                window.requestFocus();
            }
        }

        public void windowClosed(Window window, Display display, Window owner) {
            display.getContainerMouseListeners().remove((Object)CalendarButtonSkin.this.displayMouseListener);
            Window componentWindow = CalendarButtonSkin.this.getComponent().getWindow();
            if (componentWindow != null && !componentWindow.isClosing()) {
                componentWindow.moveToFront();
            }
        }
    };
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener.Adapter(){

        public boolean mouseDown(Container container, Mouse.Button button, int x, int y) {
            Display display = (Display)container;
            Component descendant = display.getDescendantAt(x, y);
            if (!CalendarButtonSkin.this.calendarPopup.isAncestor(descendant) && descendant != CalendarButtonSkin.this.getComponent()) {
                CalendarButtonSkin.this.calendarPopup.close();
            }
            return false;
        }

        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
            boolean consumed = false;
            Display display = (Display)container;
            Window window = (Window)display.getComponentAt(x, y);
            if (window != CalendarButtonSkin.this.calendarPopup) {
                consumed = true;
            }
            return consumed;
        }
    };

    public CalendarButtonSkin() {
        this.calendar = new Calendar();
        this.calendar.getCalendarListeners().add((Object)new CalendarListener.Adapter(){

            public void yearChanged(Calendar calendar, int previousYear) {
                CalendarButton calendarButton = (CalendarButton)CalendarButtonSkin.this.getComponent();
                calendarButton.setYear(calendar.getYear());
            }

            public void monthChanged(Calendar calendar, int previousMonth) {
                CalendarButton calendarButton = (CalendarButton)CalendarButtonSkin.this.getComponent();
                calendarButton.setMonth(calendar.getMonth());
            }
        });
        this.calendarPopup = new Window();
        this.calendarPopup.getComponentMouseButtonListeners().add((Object)this.calendarPopupMouseButtonListener);
        this.calendarPopup.getComponentKeyListeners().add((Object)this.calendarPopupKeyListener);
        this.calendarPopup.getWindowStateListeners().add((Object)this.calendarPopupWindowStateListener);
    }

    @Override
    public void install(Component component) {
        super.install(component);
        CalendarButton calendarButton = (CalendarButton)component;
        calendarButton.getCalendarButtonListeners().add((Object)this);
        calendarButton.getCalendarButtonSelectionListeners().add((Object)this);
        this.calendar.setLocale(calendarButton.getLocale());
    }

    @Override
    public Window getCalendarPopup() {
        return this.calendarPopup;
    }

    @Override
    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        if (!component.isEnabled()) {
            this.pressed = false;
        }
        this.repaintComponent();
        this.calendarPopup.close();
    }

    @Override
    public void focusedChanged(Component component, Component obverseComponent) {
        super.focusedChanged(component, obverseComponent);
        this.repaintComponent();
        if (!component.isFocused()) {
            this.pressed = false;
            if (!this.calendarPopup.containsFocus()) {
                this.calendarPopup.close();
            }
        }
    }

    @Override
    public void mouseOut(Component component) {
        super.mouseOut(component);
        this.pressed = false;
        this.repaintComponent();
    }

    @Override
    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseDown(component, button, x, y);
        this.pressed = true;
        this.repaintComponent();
        if (this.calendarPopup.isOpen()) {
            this.calendarPopup.close();
        } else {
            this.calendarPopup.open(component.getWindow());
        }
        return consumed;
    }

    @Override
    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseUp(component, button, x, y);
        this.pressed = false;
        this.repaintComponent();
        return consumed;
    }

    @Override
    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        if (keyCode == 32) {
            this.pressed = true;
            this.repaintComponent();
            if (this.calendarPopup.isOpen()) {
                this.calendarPopup.close();
            } else {
                this.calendarPopup.open(component.getWindow());
            }
            consumed = true;
        } else {
            consumed = super.keyPressed(component, keyCode, keyLocation);
        }
        return consumed;
    }

    @Override
    public boolean keyReleased(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        if (keyCode == 32) {
            this.pressed = false;
            this.repaintComponent();
        } else {
            consumed = super.keyReleased(component, keyCode, keyLocation);
        }
        return consumed;
    }

    @Override
    public void yearChanged(CalendarButton calendarButton, int previousYear) {
        this.calendar.setYear(calendarButton.getYear());
    }

    @Override
    public void monthChanged(CalendarButton calendarButton, int previousMonth) {
        this.calendar.setMonth(calendarButton.getMonth());
    }

    @Override
    public void localeChanged(CalendarButton calendarButton, Locale previousLocale) {
        this.calendar.setLocale(calendarButton.getLocale());
    }

    @Override
    public void disabledDateFilterChanged(CalendarButton calendarButton, Filter<CalendarDate> previousDisabledDateFilter) {
        this.calendar.setDisabledDateFilter(calendarButton.getDisabledDateFilter());
    }

    @Override
    public void selectedDateChanged(CalendarButton calendarButton, CalendarDate previousSelectedDate) {
        CalendarDate date = calendarButton.getSelectedDate();
        calendarButton.setButtonData(date);
        this.calendar.setSelectedDate(date);
        if (date != null) {
            this.calendar.setYear(date.year);
            this.calendar.setMonth(date.month);
        }
    }
}

