/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.StackPane;
import org.apache.pivot.wtk.skin.ContainerSkin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackPaneSkin
extends ContainerSkin {
    private Insets padding = Insets.NONE;

    @Override
    public int getPreferredWidth(int height) {
        int preferredWidth = 0;
        StackPane stackPane = (StackPane)this.getComponent();
        for (Component component : stackPane) {
            preferredWidth = Math.max(preferredWidth, component.getPreferredWidth(height));
        }
        return preferredWidth += this.padding.left + this.padding.right;
    }

    @Override
    public int getPreferredHeight(int width) {
        int preferredHeight = 0;
        StackPane stackPane = (StackPane)this.getComponent();
        for (Component component : stackPane) {
            preferredHeight = Math.max(preferredHeight, component.getPreferredHeight(width));
        }
        return preferredHeight += this.padding.top + this.padding.bottom;
    }

    @Override
    public Dimensions getPreferredSize() {
        int preferredWidth = 0;
        int preferredHeight = 0;
        StackPane stackPane = (StackPane)this.getComponent();
        for (Component component : stackPane) {
            Dimensions preferredCardSize = component.getPreferredSize();
            preferredWidth = Math.max(preferredWidth, preferredCardSize.width);
            preferredHeight = Math.max(preferredHeight, preferredCardSize.height);
        }
        return new Dimensions(preferredWidth += this.padding.left + this.padding.right, preferredHeight += this.padding.top + this.padding.bottom);
    }

    @Override
    public int getBaseline(int width, int height) {
        return -1;
    }

    @Override
    public void layout() {
        StackPane stackPane = (StackPane)this.getComponent();
        int width = Math.max(this.getWidth() - (this.padding.left + this.padding.right), 0);
        int height = Math.max(this.getHeight() - (this.padding.top + this.padding.bottom), 0);
        for (Component component : stackPane) {
            component.setLocation(this.padding.left, this.padding.top);
            component.setSize(width, height);
        }
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(padding));
    }
}

