/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.TextPane;
import org.apache.pivot.wtk.Visual;
import org.apache.pivot.wtk.skin.TextPaneSkinElementView;
import org.apache.pivot.wtk.text.Element;
import org.apache.pivot.wtk.text.Node;
import org.apache.pivot.wtk.text.NodeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TextPaneSkinNodeView
implements Visual,
NodeListener {
    private Node node = null;
    private TextPaneSkinElementView parent = null;
    private int width = 0;
    private int height = 0;
    private int x = 0;
    private int y = 0;
    private int breakWidth = -1;
    private boolean valid = false;

    public TextPaneSkinNodeView(Node node) {
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public TextPaneSkinElementView getParent() {
        return this.parent;
    }

    protected void setParent(TextPaneSkinElementView parent) {
        this.parent = parent;
    }

    protected void attach() {
        this.node.getNodeListeners().add((Object)this);
    }

    protected void detach() {
        this.node.getNodeListeners().remove((Object)this);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getBaseline() {
        return -1;
    }

    public Dimensions getSize() {
        return new Dimensions(this.width, this.height);
    }

    protected void setSize(int width, int height) {
        assert (width >= 0);
        assert (height >= 0);
        this.repaint();
        this.width = width;
        this.height = height;
        this.repaint();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    protected void setLocation(int x, int y) {
        this.repaint();
        this.x = x;
        this.y = y;
        this.repaint();
    }

    protected abstract void setSkinLocation(int var1, int var2);

    public Bounds getBounds() {
        return new Bounds(this.x, this.y, this.width, this.height);
    }

    public void repaint() {
        this.repaint(0, 0, this.width, this.height);
    }

    public void repaint(int x, int y, int width, int height) {
        assert (width >= 0);
        assert (height >= 0);
        if (this.parent != null) {
            this.parent.repaint(x + this.x, y + this.y, width, height);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate() {
        this.valid = false;
        if (this.parent != null) {
            this.parent.invalidate();
        }
    }

    public void validate() {
        this.valid = true;
    }

    public int getBreakWidth() {
        return this.breakWidth;
    }

    public void setBreakWidth(int breakWidth) {
        int previousBreakWidth = this.breakWidth;
        if (previousBreakWidth != breakWidth) {
            this.breakWidth = breakWidth;
            this.valid = false;
        }
    }

    public int getOffset() {
        return this.node.getOffset();
    }

    public int getDocumentOffset() {
        return this.parent == null ? 0 : this.parent.getDocumentOffset() + this.getOffset();
    }

    public int getCharacterCount() {
        return this.node.getCharacterCount();
    }

    public abstract TextPaneSkinNodeView getNext();

    public abstract int getInsertionPoint(int var1, int var2);

    public abstract int getNextInsertionPoint(int var1, int var2, TextPane.ScrollDirection var3);

    public abstract int getRowAt(int var1);

    public abstract int getRowCount();

    public abstract Bounds getCharacterBounds(int var1);

    @Override
    public void parentChanged(Node node, Element previousParent) {
    }

    @Override
    public void offsetChanged(Node node, int previousOffset) {
    }

    @Override
    public void rangeInserted(Node node, int offset, int span) {
    }

    @Override
    public void rangeRemoved(Node node, int offset, int characterCount) {
    }

    @Override
    public void nodesRemoved(Node node, Sequence<Node> removed, int offset) {
    }

    @Override
    public void nodeInserted(Node node, int offset) {
    }
}

