/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.TextPane;
import org.apache.pivot.wtk.skin.TextPaneSkin;
import org.apache.pivot.wtk.skin.TextPaneSkinBlockView;
import org.apache.pivot.wtk.skin.TextPaneSkinNodeView;
import org.apache.pivot.wtk.text.Node;
import org.apache.pivot.wtk.text.Paragraph;

class TextPaneSkinParagraphView
extends TextPaneSkinBlockView {
    private static final int PARAGRAPH_TERMINATOR_WIDTH = 4;
    private final TextPaneSkin textPaneSkin;
    private ArrayList<Row> rows = null;
    private Bounds terminatorBounds = new Bounds(0, 0, 0, 0);

    public TextPaneSkinParagraphView(TextPaneSkin textPaneSkin, Paragraph paragraph) {
        super(paragraph);
        this.textPaneSkin = textPaneSkin;
    }

    public void invalidate() {
        super.invalidate();
        this.terminatorBounds = null;
    }

    public void validate() {
        if (!this.isValid()) {
            int breakWidth = this.getBreakWidth();
            Paragraph paragraph = (Paragraph)this.getNode();
            this.rows = new ArrayList();
            Row row = new Row();
            for (Node node : paragraph) {
                TextPaneSkinNodeView nodeView = this.textPaneSkin.createNodeView(node);
                nodeView.setBreakWidth(Math.max(breakWidth - (row.width + 4), 0));
                nodeView.validate();
                int nodeViewWidth = nodeView.getWidth();
                if (row.width + nodeViewWidth > breakWidth && row.width > 0) {
                    this.rows.add((Object)row);
                    row = new Row();
                    row.width = 0;
                }
                row.nodeViews.add((Object)nodeView);
                row.width += nodeViewWidth;
                for (nodeView = nodeView.getNext(); nodeView != null; nodeView = nodeView.getNext()) {
                    this.rows.add((Object)row);
                    row = new Row();
                    nodeView.setBreakWidth(breakWidth);
                    nodeView.validate();
                    row.nodeViews.add((Object)nodeView);
                    row.width = nodeView.getWidth();
                }
            }
            if (row.nodeViews.getLength() > 0) {
                this.rows.add((Object)row);
            }
            this.remove(0, this.getLength());
            int x = 0;
            int width = 0;
            int height = 0;
            int n = this.rows.getLength();
            for (int i = 0; i < n; ++i) {
                row = (Row)this.rows.get(i);
                row.y = height;
                width = Math.max(width, row.width);
                for (TextPaneSkinNodeView nodeView : row.nodeViews) {
                    row.height = Math.max(row.height, nodeView.getHeight());
                }
                x = paragraph.getHorizontalAlignment() == HorizontalAlignment.LEFT ? 0 : (paragraph.getHorizontalAlignment() == HorizontalAlignment.CENTER ? (width - row.width) / 2 : width - row.width);
                for (TextPaneSkinNodeView nodeView : row.nodeViews) {
                    int y = row.height - nodeView.getHeight();
                    nodeView.setLocation(x, y + height);
                    x += nodeView.getWidth();
                    this.add(nodeView);
                }
                height += row.height;
            }
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            LineMetrics lm = this.textPaneSkin.getFont().getLineMetrics("", 0, 0, fontRenderContext);
            int terminatorHeight = (int)Math.ceil(lm.getHeight());
            int terminatorY = this.getCharacterCount() == 1 ? 0 : height - terminatorHeight;
            this.terminatorBounds = new Bounds(x, terminatorY, 4, terminatorHeight);
            height = Math.max(height, this.terminatorBounds.height);
            this.setSize(width += this.terminatorBounds.width, height);
        }
        super.validate();
    }

    protected void setSkinLocation(int skinX, int skinY) {
        int n = this.rows.getLength();
        for (int i = 0; i < n; ++i) {
            Row row = (Row)this.rows.get(i);
            for (TextPaneSkinNodeView nodeView : row.nodeViews) {
                nodeView.setSkinLocation(skinX + nodeView.getX(), skinY + nodeView.getY());
            }
        }
    }

    public TextPaneSkinNodeView getNext() {
        return null;
    }

    public int getInsertionPoint(int x, int y) {
        int offset;
        block3: {
            block4: {
                offset = -1;
                int n = this.rows.getLength();
                if (n <= 0) break block4;
                for (int i = 0; i < n; ++i) {
                    block5: {
                        Row row;
                        block7: {
                            block6: {
                                row = (Row)this.rows.get(i);
                                if (y < row.y || y >= row.y + row.height) break block5;
                                if (x >= row.x) break block6;
                                TextPaneSkinNodeView firstNodeView = (TextPaneSkinNodeView)row.nodeViews.get(0);
                                offset = firstNodeView.getOffset();
                                break block5;
                            }
                            if (x <= row.x + row.width - 1) break block7;
                            TextPaneSkinNodeView lastNodeView = (TextPaneSkinNodeView)row.nodeViews.get(row.nodeViews.getLength() - 1);
                            offset = lastNodeView.getOffset() + lastNodeView.getCharacterCount();
                            if (offset >= this.getCharacterCount() - 1) break block5;
                            --offset;
                            break block5;
                        }
                        for (TextPaneSkinNodeView nodeView : row.nodeViews) {
                            Bounds nodeViewBounds = nodeView.getBounds();
                            if (!nodeViewBounds.contains(x, y)) continue;
                            offset = nodeView.getInsertionPoint(x - nodeView.getX(), y - nodeView.getY()) + nodeView.getOffset();
                            break;
                        }
                    }
                    if (offset == -1) {
                        continue;
                    }
                    break block3;
                }
                break block3;
            }
            offset = this.getCharacterCount() - 1;
        }
        return offset;
    }

    public int getNextInsertionPoint(int x, int from, TextPane.ScrollDirection direction) {
        int offset = -1;
        int n = this.rows.getLength();
        if (n == 0 && from == -1) {
            offset = 0;
        } else {
            Row row;
            int i;
            if (from == -1) {
                i = direction == TextPane.ScrollDirection.DOWN ? -1 : this.rows.getLength();
            } else if (from == this.getCharacterCount() - 1) {
                i = this.rows.getLength() - 1;
            } else {
                for (i = 0; i < n; ++i) {
                    row = (Row)this.rows.get(i);
                    TextPaneSkinNodeView firstNodeView = (TextPaneSkinNodeView)row.nodeViews.get(0);
                    TextPaneSkinNodeView lastNodeView = (TextPaneSkinNodeView)row.nodeViews.get(row.nodeViews.getLength() - 1);
                    if (from >= firstNodeView.getOffset() && from < lastNodeView.getOffset() + lastNodeView.getCharacterCount()) break;
                }
            }
            i = direction == TextPane.ScrollDirection.DOWN ? ++i : --i;
            if (i >= 0 && i < n) {
                TextPaneSkinNodeView lastNodeView;
                row = (Row)this.rows.get(i);
                for (TextPaneSkinNodeView nodeView : row.nodeViews) {
                    Bounds bounds = nodeView.getBounds();
                    if (x < bounds.x || x >= bounds.x + bounds.width) continue;
                    offset = nodeView.getNextInsertionPoint(x - nodeView.getX(), -1, direction) + nodeView.getOffset();
                    break;
                }
                if (offset == -1 && (offset = (lastNodeView = (TextPaneSkinNodeView)row.nodeViews.get(row.nodeViews.getLength() - 1)).getOffset() + lastNodeView.getCharacterCount()) < this.getCharacterCount() - 1) {
                    --offset;
                }
            }
        }
        return offset;
    }

    public int getRowAt(int offset) {
        int rowIndex = -1;
        if (offset == this.getCharacterCount() - 1) {
            rowIndex = this.rows.getLength() == 0 ? 0 : this.rows.getLength() - 1;
        } else {
            int n = this.rows.getLength();
            for (int i = 0; i < n; ++i) {
                Row row = (Row)this.rows.get(i);
                TextPaneSkinNodeView firstNodeView = (TextPaneSkinNodeView)row.nodeViews.get(0);
                TextPaneSkinNodeView lastNodeView = (TextPaneSkinNodeView)row.nodeViews.get(row.nodeViews.getLength() - 1);
                if (offset < firstNodeView.getOffset() || offset >= lastNodeView.getOffset() + lastNodeView.getCharacterCount()) continue;
                rowIndex = i;
                break;
            }
        }
        return rowIndex;
    }

    public int getRowCount() {
        return Math.max(this.rows.getLength(), 1);
    }

    public Bounds getCharacterBounds(int offset) {
        Bounds bounds = offset == this.getCharacterCount() - 1 ? this.terminatorBounds : super.getCharacterBounds(offset);
        return bounds;
    }

    private static class Row {
        public int x = 0;
        public int y = 0;
        public int width = 0;
        public int height = 0;
        public ArrayList<TextPaneSkinNodeView> nodeViews = new ArrayList();

        private Row() {
        }
    }
}

