/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Color;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.FocusTraversalDirection;
import org.apache.pivot.wtk.FocusTraversalPolicy;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowListener;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.ContainerSkin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowSkin
extends ContainerSkin
implements Window.Skin,
WindowListener,
WindowStateListener {
    public WindowSkin() {
        this.setBackgroundColor(Color.WHITE);
    }

    @Override
    public void install(Component component) {
        super.install(component);
        Window window = (Window)component;
        window.getWindowListeners().add((Object)this);
        window.getWindowStateListeners().add((Object)this);
        window.setFocusTraversalPolicy(new WindowFocusTraversalPolicy());
    }

    @Override
    public int getPreferredWidth(int height) {
        Window window = (Window)this.getComponent();
        Component content = window.getContent();
        return content != null ? content.getPreferredWidth(height) : 0;
    }

    @Override
    public int getPreferredHeight(int width) {
        Window window = (Window)this.getComponent();
        Component content = window.getContent();
        return content != null ? content.getPreferredHeight(width) : 0;
    }

    @Override
    public Dimensions getPreferredSize() {
        Window window = (Window)this.getComponent();
        Component content = window.getContent();
        return content != null ? content.getPreferredSize() : new Dimensions(0, 0);
    }

    @Override
    public void layout() {
        Window window = (Window)this.getComponent();
        Component content = window.getContent();
        if (content != null) {
            content.setSize(window.getSize());
        }
    }

    @Override
    public Bounds getClientArea() {
        return new Bounds(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public boolean mouseDown(Container container, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseDown(container, button, x, y);
        Window window = (Window)container;
        window.moveToFront();
        return consumed;
    }

    @Override
    public void titleChanged(Window window, String previousTitle) {
    }

    @Override
    public void iconAdded(Window window, Image addedIcon) {
    }

    @Override
    public void iconInserted(Window window, Image addedIcon, int index) {
    }

    @Override
    public void iconsRemoved(Window window, int index, Sequence<Image> removed) {
    }

    @Override
    public void contentChanged(Window window, Component previousContent) {
        this.invalidateComponent();
    }

    @Override
    public void activeChanged(Window window, Window obverseWindow) {
    }

    @Override
    public void maximizedChanged(Window window) {
    }

    @Override
    public void windowOpened(Window window) {
    }

    @Override
    public Vote previewWindowClose(Window window) {
        return Vote.APPROVE;
    }

    @Override
    public void windowCloseVetoed(Window window, Vote reason) {
    }

    @Override
    public void windowClosed(Window window, Display display, Window owner) {
    }

    public static class WindowFocusTraversalPolicy
    implements FocusTraversalPolicy {
        public Component getNextComponent(Container container, Component component, FocusTraversalDirection direction) {
            assert (container instanceof Window) : "container is not a Window";
            if (direction == null) {
                throw new IllegalArgumentException("direction is null.");
            }
            Window window = (Window)container;
            return window.getContent();
        }
    }
}

