package com.interactivemesh.j3d.testspace.canvas3d;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;

import javax.swing.JFrame;
import javax.swing.UIManager;

/*
 * PropellerUniverseJWS.java
 *
 * Version: 2.0
 * Date: 2012/08/26
 *
 * Copyright (c) 2009-2012
 * August Lammersdorf, InteractiveMesh e.K.
 * Hauptstrae 28d, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'PropellerUniverseJWS.java'.
 *
 */

final public class PropellerUniverseJWS {
    
    public static void main(String[] args) {
        
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception e) {           
        }
        
        new PropellerUniverseJWS();
    }

    private PropellerUniverseJWS() {

        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        
        JFrame jFrame = new JFrame();
        jFrame.setTitle("InteractiveMesh : Heavyweight Internal Frames");
        jFrame.setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        JFrame jFrameFull = new JFrame();
        jFrameFull.setUndecorated(true);
        jFrameFull.setSize(screenDim);       
        
        PropellerUniversePanel panel = new PropellerUniversePanel();       
        panel.addTo(jFrame, jFrameFull);
        
        int frameWidth = (int)(screenDim.width * 0.8f);
        int frameHeight = (int)(screenDim.height * 0.8f);
       
        jFrame.setSize(frameWidth, frameHeight);
        jFrame.setLocation((screenDim.width - frameWidth)/2, (screenDim.height - frameHeight)/2);

        jFrame.setVisible(true);
    }   
}
