package com.interactivemesh.j3d.testspace.canvas3d;

import javax.swing.JApplet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

import javax.swing.border.Border;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import javax.imageio.ImageIO;

import javax.media.j3d.Canvas3D;

import com.interactivemesh.j3d.testspace.canvas3d.PropellerUniverse.Vp;

/*
 * PropellerUniversePanel.java
 *
 * Version: 2.0
 * Date: 2012/08/26
 *
 * Copyright (c) 2009-2012
 * August Lammersdorf, InteractiveMesh e.K.
 * Hauptstrae 28d, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'PropellerUniversePanel.java'.
 *
 */

final class PropellerUniversePanel {
        
    private Font    			titleFont       =   null; 
    private Font    			textFont        =   null; 

    private int     			borderLR        =   50;       
    private int     			space           =   10;
    private int     			vspace          =   5;

    private Cursor  			defaultCursor   =  new Cursor(Cursor.DEFAULT_CURSOR);
//  private Cursor  			dragCursor      =   new Cursor(Cursor.MOVE_CURSOR);
    private Cursor  			titleCursor     =   new Cursor(Cursor.HAND_CURSOR);
    
    private Color   			desktopColor    =   new Color(0.0f, 0.4f, 0.8f);
    private Color   			panelColor      =   new Color(0.55f, 0.6f, 0.753f);
    private Color   			fgColor         =   new Color(1.0f, 1.0f, 1.0f);
    
    private Color   			enterColor      =   new Color(1.0f, 0.7f, 0.0f);     // orange
    private Color   			pressColor      =   new Color(1.0f, 0.2f, 0.0f);     // dark orange            
    private Color   			selectColor     =   new Color(0.0f, 1.0f, 0.6f);     // neon green
    private Color   			disabledColor   =   new Color(0.35f, 0.35f, 0.35f);  // 
    
    private PropellerUniverse   universe        =   null;
    
    private JFrame              jFrame          =   null;
    private JFrame              jFrameFull      =   null;
    private boolean             isFullScreen    =   false;
    private boolean             isApplet        =   false;
    
    private JPanel              applicationPanel =  null;
    private JDesktopPane        jDesktopPane    =   null;
    private DesktopManager3D    desktopManager  =   null;
    private int                 currDragMode    =   JDesktopPane.OUTLINE_DRAG_MODE;

    private InternalFrame3D[]   iFrame3Ds       =   null;    
    private ControlFrame        controlFrame    =   null;    
    private JPanel              actionPanel     =   null;
    
    private FrameLayout         currFrameLayout =   FrameLayout.DISCRET;
    
    private int                 actionWidth     =   1;
    private int                 actionHeight    =   1;       

    private Label               fpsValueLabel   =   null;
    
    // Outlines for dragging and resizing
    private OutlinePanels       outlinePanels   =   null;
    
    // InternalFrame border
    private Border              iframeBorder    =   null;
    private Border              emptyBorder     =   null;
    
    private Slider              rotationSlider  =   null;
    private RadioLabelGroup     layoutGroup     =   null;
    
    private BufferedImage       bgImage         =   null;
    
    private Timer				fpsResetTimer	=	null;

    private enum FrameLayout {
        DISCRET,
        OVERLAP,
        NONE;
    }
    
//private Method mSetComponentMixing = null;

    PropellerUniversePanel() {
        // NoTitleIFrameUI
        UIManager.put("InternalFrameUI", "com.interactivemesh.j3d.testspace.canvas3d.NoTitleIFrameUI");  
        
        final ActionListener fpsResetListener = new ActionListener() {
        	public void actionPerformed(ActionEvent event) {
        		setFPS(0);
        	}
        };
        fpsResetTimer = new Timer(100, fpsResetListener);
        fpsResetTimer.setRepeats(false);
/*        
try {
    Class awtUtilitiesClass = Class.forName("com.sun.awt.AWTUtilities");
    mSetComponentMixing = awtUtilitiesClass.getMethod("setComponentMixingCutoutShape",
                                                      Component.class, Shape.class);
} catch (NoSuchMethodException ex) {
    ex.printStackTrace();
} catch (SecurityException ex) {
    ex.printStackTrace();
} catch (ClassNotFoundException ex) {
    ex.printStackTrace();
} catch (IllegalArgumentException ex) {
    ex.printStackTrace();
}
*/
    }
    
    // JApplet
    void destroy() {
        universe.closeUniverse();
    }
    
    void addTo(JApplet applet) {
        isApplet = true;
        
        setupDesign();
        createApplicationPanel();
        
        applet.add(applicationPanel);
    }
    
    void addTo(JFrame frame, JFrame framefull) {        
        jFrame = frame;
        jFrameFull = framefull;
        
        setupDesign();
        createApplicationPanel();
        
        jFrame.add(applicationPanel);
    }
    
    private void setupDesign() {
        
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int screenHeight = screenDim.height;
        
        // screenHeight >= 1200
        int textFontSize = 18;
        int titleFontSize = 48;
        this.borderLR = 50;
        this.space = 10;

        // screenHeight  < 1024
        if ( (!isApplet && screenHeight < 1024) || (isApplet && screenHeight < 1200) ) {
            textFontSize = 14;
            titleFontSize = 36;
            this.borderLR = 30;
            this.space = 5;
        }
        // 1024 <= screenHeight < 1200
        else if ( (!isApplet && screenHeight < 1200) || (isApplet && screenHeight >= 1200) ) {
            textFontSize = 16;
            titleFontSize = 42;
            this.borderLR = 40;
            this.space = 8;
        }
        
        this.titleFont = new Font("Serif", Font.ITALIC, titleFontSize); 
        this.textFont = new Font("Dialog", Font.PLAIN, textFontSize); 
    }
    
    private void toggleFrame(boolean fullscreen) {
        if (isFullScreen == fullscreen)
            return;
        if (fullscreen) {
            jFrame.setVisible(false);
            jFrame.remove(applicationPanel);
            jFrameFull.add(applicationPanel);
            jFrameFull.setVisible(true);
        }
        else {
            jFrameFull.setVisible(false);
            jFrameFull.remove(applicationPanel);
            jFrame.add(applicationPanel);
            jFrame.setVisible(true);
        }
        isFullScreen = fullscreen;
    }
    
    private void createApplicationPanel() {
        
        ToolTipManager ttManager = ToolTipManager.sharedInstance();
        ttManager.setEnabled(true);
        ttManager.setLightWeightPopupEnabled(false);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);

        iframeBorder = BorderFactory.createRaisedBevelBorder();
        emptyBorder = BorderFactory.createEmptyBorder();
               
        universe = new PropellerUniverse(this);
                       
        //
        // Actions
        //
        
        // Layout
        
        YPanel layoutPanel = new YPanel() {
            @Override
            public void paintComponent(Graphics g) {               
                super.paintComponent(g);                
                Dimension size = this.getSize();
                g.setColor(Color.WHITE);                
                // Horizontal line
                g.drawLine(0, size.height/2, size.width, size.height/2);
            }
        };

        RadioLabel la0Radio = new RadioLabel("Discret", 0, 5, 0, 5, "Layout Discret");       
        RadioLabel la1Radio = new RadioLabel("Overlap", 0, 5, 0, 5, "Layout Overlap");
        
        layoutGroup = new RadioLabelGroup() {
            @Override
            void selectionChanged(RadioLabel radio) {
                boolean isChanged = false;
                if (radio == null) {
                    if (currFrameLayout != FrameLayout.NONE) {
                        currFrameLayout = FrameLayout.NONE;
                        isChanged = true;
                    }
                }
                else {
                    if (radio.getText().equalsIgnoreCase("Discret") &&
                        currFrameLayout != FrameLayout.DISCRET) {
                        currFrameLayout = FrameLayout.DISCRET;
                        isChanged = true;
                    }
                    else if (radio.getText().equalsIgnoreCase("Overlap") &&
                             currFrameLayout != FrameLayout.OVERLAP) {
                        currFrameLayout = FrameLayout.OVERLAP;
                        isChanged = true;
                    }
                }
                if (isChanged)
                    setupDesktopPane(jDesktopPane.getSize());
            }
        };
        layoutGroup.add(la0Radio);
        layoutGroup.add(la1Radio);
        layoutGroup.setSelection(la0Radio);
       
        layoutPanel.add(la0Radio);
        layoutPanel.add(Box.createVerticalStrut(vspace));
        layoutPanel.add(la1Radio);
    
        
        // Rotation
       
        YPanel rotationPanel = new YPanel();
        
        SingleButtonLabel rotationButton = new SingleButtonLabel("<< Rotation > ", "Reset rotation") {
            @Override
            void action() {
                universe.resetRotation();
                rotationSlider.setAtValue(50);
            }
        };
        
        Dimension sliderSize = new Dimension((int)(rotationButton.getPreferredSize().width * 1.4f), 
                                                   rotationButton.getPreferredSize().height);
 
        rotationSlider = new Slider(0, 100, 50, sliderSize) {        
            @Override
            public void valueChanged(int value) {
                universe.setRotationSpeed(value);
            }
        };
        
        rotationPanel.add(rotationButton);
        rotationPanel.add(Box.createVerticalGlue());
        rotationPanel.add(rotationSlider);
               
        // Frames per second
        
        YPanel fpsPanel = new YPanel();

        Label fpsLabel = new Label("F P S");
        fpsLabel.setToolTipText("Frames per second");
        if (universe.isD3D())
        	fpsLabel.setToolTipText("Frames per second ( limited )");
        
        fpsValueLabel = new Label("0", "Current frames per second");

        fpsPanel.add(fpsLabel);
        fpsPanel.add(fpsValueLabel);
                        
        // Drag mode
        
        YPanel dragmodePanel = new YPanel() {
            @Override
            public void paintComponent(Graphics g) {               
                super.paintComponent(g);                
                Dimension size = this.getSize();
                g.setColor(Color.WHITE);                
                // Horizontal line
                g.drawLine(0, size.height/2, size.width, size.height/2);
            }
        };        
        
        RadioLabel liveRadio = new RadioLabel("Live", 0, 5, 0, 5, "Live drag mode");       
        RadioLabel outlRadio = new RadioLabel("Outline", 0, 5, 0, 5, "Outline drag mode");
        
        RadioLabelGroup projGroup = new RadioLabelGroup() {
            @Override
            void selectionChanged(RadioLabel radio) {
                if (radio.getText().equalsIgnoreCase("Live") &&
                    currDragMode != JDesktopPane.LIVE_DRAG_MODE) 
                    currDragMode = JDesktopPane.LIVE_DRAG_MODE;
                else if (radio.getText().equalsIgnoreCase("Outline") &&
                         currDragMode != JDesktopPane.OUTLINE_DRAG_MODE)
                    currDragMode = JDesktopPane.OUTLINE_DRAG_MODE;
                
                jDesktopPane.setDragMode(currDragMode);
            }
        };
        projGroup.add(liveRadio);
        projGroup.add(outlRadio);
        projGroup.setSelection(outlRadio);
        
        dragmodePanel.add(liveRadio);
        dragmodePanel.add(Box.createVerticalStrut(vspace));
        dragmodePanel.add(outlRadio);
        
        
        actionPanel = new JPanel();
        actionPanel.setOpaque(true);               // TODO Test : false
        actionPanel.setBackground(panelColor);
        actionPanel.setLayout(new BoxLayout(actionPanel, BoxLayout.X_AXIS));
        actionPanel.setBorder(BorderFactory.createEmptyBorder(vspace, vspace, vspace, vspace));
        
Component strut1 = Box.createHorizontalStrut(space);
Component strut2 = Box.createHorizontalStrut(space);
Component strut3 = Box.createHorizontalStrut(space);

//        actionPanel.add(Box.createHorizontalStrut(space));
        actionPanel.add(layoutPanel);
        actionPanel.add(strut1);
        actionPanel.add(rotationPanel);
        actionPanel.add(strut2);
        actionPanel.add(fpsPanel);
        actionPanel.add(strut3);
        actionPanel.add(dragmodePanel);
//        actionPanel.add(Box.createHorizontalStrut(space));
        
        // InternalFrame Controls
        controlFrame = new ControlFrame();
        controlFrame.add(actionPanel);
        
        Dimension actionSize = controlFrame.getPreferredSize();
        actionWidth = actionSize.width;
        actionHeight = actionSize.height;      
        
        //
        // 3D Scene
        //
        
        // InternalFrames3D
        iFrame3Ds = new InternalFrame3D[4];
        
        // InternalFrame background Viewpoint FRONT
        iFrame3Ds[0] = new Frame3DBack(universe.getCanvas3D(Vp.FRONT), Vp.FRONT);
        
        // InternalFrame Viewpoint ROD
        iFrame3Ds[1] = new Frame3D(universe.getCanvas3D(Vp.ROD), Vp.ROD);
        
        // InternalFrame  Viewpoint PISTON
        iFrame3Ds[2] = new Frame3D(universe.getCanvas3D(Vp.PISTON), Vp.PISTON);
        
        // InternalFrame  Viewpoint ONROD
        iFrame3Ds[3] = new Frame3D(universe.getCanvas3D(Vp.ONROD), Vp.ONROD);
        
        // Canvas3D desktop
        jDesktopPane = new JDesktopPane();
//        jDesktopPane.setBackground(desktopColor);
        jDesktopPane.setDragMode(currDragMode);
        
        // Canvas3D DesktopManager
        desktopManager = new DesktopManager3D();
        jDesktopPane.setDesktopManager(desktopManager);
        
        jDesktopPane.add(iFrame3Ds[0], new Integer(0)); // background
        jDesktopPane.add(iFrame3Ds[1], new Integer(1));
        jDesktopPane.add(iFrame3Ds[2], new Integer(1));        
        jDesktopPane.add(iFrame3Ds[3], new Integer(1));
        jDesktopPane.add(controlFrame, JDesktopPane.PALETTE_LAYER); // controls
                               
        jDesktopPane.addComponentListener(new ComponentAdapter() { 
            public void componentResized(ComponentEvent event) {
                setupDesktopPane(jDesktopPane.getSize());
            }
        });
                                
        // Dragging / Resizing outline
        outlinePanels = new OutlinePanels();      
        jDesktopPane.add(outlinePanels.eastLine, JLayeredPane.DRAG_LAYER);
        jDesktopPane.add(outlinePanels.northLine, JLayeredPane.DRAG_LAYER);
        jDesktopPane.add(outlinePanels.southLine, JLayeredPane.DRAG_LAYER);
        jDesktopPane.add(outlinePanels.westLine, JLayeredPane.DRAG_LAYER);
       
        // Background image, also used in 3D scene        
        URL imageUrl = this.getClass().getResource("resources/bg.jpg");       
        try {
            bgImage = ImageIO.read(imageUrl);
        }
        catch (IOException e) {
        }
        
        applicationPanel = new JPanel() {
            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (bgImage != null)
                    g.drawImage(bgImage, 0, 0, this.getWidth(), this.getHeight(), null);
                
            }
        };
        applicationPanel.setLayout(new BoxLayout(applicationPanel, BoxLayout.Y_AXIS));
        applicationPanel.setBorder(BorderFactory.createEmptyBorder(0, borderLR, borderLR, borderLR));
        
        // Title
    
        JLabel titleLabel = new JLabel("H'weight & L'weight in Harmony");
        titleLabel.setFont(titleFont);
        titleLabel.setForeground(fgColor);
        titleLabel.setAlignmentX(JComponent.CENTER_ALIGNMENT);
        titleLabel.setAlignmentY(JComponent.CENTER_ALIGNMENT);
        
        JPanel titelPanel = new JPanel();
        titelPanel.setLayout(new BoxLayout(titelPanel, BoxLayout.Y_AXIS));
        titelPanel.setOpaque(false);
        titelPanel.setBorder(BorderFactory.createEmptyBorder());
        titelPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, borderLR*2));
        
        titelPanel.add(titleLabel);
        
        JPanel desktopBorderPanel = new JPanel(new BorderLayout());
        desktopBorderPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        
        desktopBorderPanel.add(jDesktopPane, BorderLayout.CENTER);
        
        applicationPanel.add(titelPanel);
        applicationPanel.add(Box.createVerticalStrut(space));
        applicationPanel.add(desktopBorderPanel);
        
/*        
try {
//          Area are0 = new Area(new Rectangle(outline.x+4, outline.y+28+5, outline.width, outline.height));
//          are0.subtract( new Area(new Rectangle(outline.x+6, outline.y+28+7, outline.width-4, outline.height-4)));
  mSetComponentMixing.invoke(null, controlFrame, new Rectangle());
  mSetComponentMixing.invoke(null, controlFrame.getContentPane(), new Rectangle());
  mSetComponentMixing.invoke(null, controlFrame.getLayeredPane(), new Rectangle());
  mSetComponentMixing.invoke(null, controlFrame.getRootPane(), new Rectangle());
  mSetComponentMixing.invoke(null, actionPanel, new Rectangle());
  mSetComponentMixing.invoke(null, rotationPanel, new Rectangle());
          
//          mSetComponentMixing.invoke(null, rotationPanel, new Rectangle());     
          
      mSetComponentMixing.invoke(null, strut1, new Rectangle());
      mSetComponentMixing.invoke(null, strut2, new Rectangle());
      mSetComponentMixing.invoke(null, strut3, new Rectangle());
      
  } catch (SecurityException ex) {
      ex.printStackTrace();
  } catch (IllegalAccessException ex) {
      ex.printStackTrace();
  } catch (IllegalArgumentException ex) {
      ex.printStackTrace();
  } catch (InvocationTargetException ex) {
      ex.printStackTrace();
  }
*/        
    }
    
    // Bounds, called also from applet               
    void setupDesktopPane(Dimension size) {
               
        if (currFrameLayout == FrameLayout.NONE) {
            // no-op           
        }
        else {
            int iframesHeight = size.height - borderLR*2;
            int iframeHeight = 0;
        
            int iFrameWidth = (int)(size.width * 0.3f);
        
            int frameX = borderLR;
            int frameY = borderLR;
            int fspace = space;
            
            if (currFrameLayout == FrameLayout.DISCRET) {
                iframeHeight = (int)((iframesHeight - fspace*2)/3.0f);
                                
                iFrame3Ds[1].setBounds(frameX, frameY, iFrameWidth, iframeHeight); 
                iFrame3Ds[2].setBounds(frameX, frameY+iframeHeight+fspace, iFrameWidth, iframeHeight); 
                iFrame3Ds[3].setBounds(frameX, frameY+(iframeHeight+fspace)*2, iFrameWidth, iframeHeight); 
                
                controlFrame.setBounds(size.width-actionWidth-borderLR, 
                                       size.height-actionHeight-borderLR, 
                                       actionWidth, actionHeight);
            }
            else if (currFrameLayout == FrameLayout.OVERLAP) {
                fspace *= 2;
                iframeHeight = (int)(iframesHeight/3.0f) + fspace;
                
                iFrame3Ds[1].setBounds(frameX, frameY, iFrameWidth, iframeHeight); 
                iFrame3Ds[2].setBounds(frameX*2, frameY+iframeHeight-fspace, iFrameWidth, iframeHeight); 
                iFrame3Ds[3].setBounds(frameX*3, frameY+(iframeHeight-fspace)*2, iFrameWidth, iframeHeight); 
                
                controlFrame.setBounds(size.width-actionWidth-borderLR, borderLR, 
                                       actionWidth, actionHeight); 
            }
        }
                
        // Background frame
        iFrame3Ds[0].setBounds(0, 0, size.width, size.height);
        
        jDesktopPane.revalidate(); 
        
//jFrame.validate();
        
        jDesktopPane.repaint();
    }
    
    // Frames per second update, called from 3D scene
    void setFPS(int fps) {
        fpsValueLabel.setText(Integer.toString(fps));
    }
    
    //
    // GUI components
    //
    
    //           JInternalFrame
    //                 |
    //            InternalFrame
    //          |                |
    //   InternalFrame3D    ControlFrame
    //    |           |
    // Frame3D   Frame3DBack
    //
    
    private abstract class InternalFrame extends JInternalFrame {

        boolean isDragging = false;
        int startX = 0;
        int startY = 0;

        private InternalFrame() {            
            this.setClosable(false);            
            this.setMaximizable(false);
            this.setResizable(false);
            this.setIconifiable(false);      
            
            this.setLayout(new BorderLayout());            
        }       
    }
    
    private final class ControlFrame extends InternalFrame {
        
        private boolean isOutlineDragMode = false;
        
        private ControlFrame() {
            
            this.setBorder(BorderFactory.createEmptyBorder());
            
            // Dragging
            this.addMouseMotionListener(new MouseMotionAdapter() {
                public void mouseDragged(MouseEvent event) {                    
                    if (isDragging) {
                        desktopManager.dragFrame(ControlFrame.this, 
                                ControlFrame.this.getX() + (event.getX()-startX), 
                                ControlFrame.this.getY() + (event.getY()-startY));
                    }
                }
            });
            // Dragging
            this.addMouseListener(new MouseAdapter() { 
                @Override
                public void mousePressed(MouseEvent event) {
                    if (SwingUtilities.isLeftMouseButton(event)) {
                        
                        if (currDragMode == JDesktopPane.OUTLINE_DRAG_MODE) {
                            isOutlineDragMode = true;
                            currDragMode = JDesktopPane.LIVE_DRAG_MODE;
                            jDesktopPane.setDragMode(currDragMode);
                        }
                        startX = event.getX();
                        startY = event.getY();
                        isDragging = true;
                        desktopManager.beginDraggingFrame(ControlFrame.this);
                    }
                }
                @Override
                public void mouseReleased(MouseEvent event) {
                    if (isDragging) {
                        desktopManager.endDraggingFrame(ControlFrame.this);
                        isDragging = false;
                        if (isOutlineDragMode) {
                            isOutlineDragMode = false;
                            currDragMode = JDesktopPane.OUTLINE_DRAG_MODE;
                            jDesktopPane.setDragMode(currDragMode);
                        }
                    }
                }
            });
            
            this.setVisible(true);           
        }       
        
        // Isn't selectable
        @Override
        public void setSelected(boolean selected) {           
        }
    }
    
    private abstract class InternalFrame3D extends InternalFrame {
        
        private Canvas3D canvas = null;
        private Vp vp = null;
        
        private InternalFrame3D(Canvas3D canvas, Vp vp) {
            this.canvas = canvas;
            this.vp = vp;
            
            this.add(canvas, BorderLayout.CENTER);            
        }
        
        Vp getVp() {
            return vp;
        }
        
        void minMaxFrame() {           
        }
    }
    
    private final class Frame3D extends InternalFrame3D {
        
        private boolean isOverTitle = false;
        
        private Frame3D(Canvas3D canvas, Vp vp) {
            super(canvas, vp);
            
            this.setIconifiable(true);            
            this.setMaximizable(true);
            this.setResizable(true);

            this.setBorder(iframeBorder);
                        
            // Dragging
            canvas.addMouseMotionListener(new MouseMotionAdapter() {
                @Override
                public void mouseDragged(MouseEvent event) {                    
                    if (isDragging) {
                        desktopManager.dragFrame(Frame3D.this, 
                                Frame3D.this.getX() + (event.getX()-startX), 
                                Frame3D.this.getY() + (event.getY()-startY));
                    }
                }
                @Override
                public void mouseMoved(MouseEvent event) {
                    setTitleCursor( (event.getY() < 20) );                        
                }
            });
            // Dragging, minimize, maximize, PopupMenu
            canvas.addMouseListener(new MouseAdapter() { 
                @Override
                public void mouseEntered(MouseEvent event) {
                    setTitleCursor( (event.getY() < 20) );                        
                }
                @Override
                public void mouseExited(MouseEvent event) {
                    setTitleCursor(false);
                }
                @Override
                public void mouseClicked(MouseEvent event) {
                    if (event.getY() < 20 && 
                        event.getClickCount() == 2 &&
                        SwingUtilities.isLeftMouseButton(event)) {
                        
                        minMaxFrame();
                    }
                    else if (SwingUtilities.isRightMouseButton(event)) {
                        PopupMenu3D menu = new PopupMenu3D(Frame3D.this);
                        menu.show(Frame3D.this, event.getX()+3, event.getY()+3);
                    }
                }
                @Override
                public void mousePressed(MouseEvent event) {
                    if (event.getY() < 20 && 
                        SwingUtilities.isLeftMouseButton(event) &&
                        !Frame3D.this.isMaximum()) {
                        startX = event.getX();
                        startY = event.getY();
                        isDragging = true;
                        desktopManager.beginDraggingFrame(Frame3D.this);
                        setTitleCursor(false);
                    }
                }
                @Override
                public void mouseReleased(MouseEvent event) {
                    if (isDragging) {
                        desktopManager.endDraggingFrame(Frame3D.this);
                        isDragging = false;
                        setTitleCursor(true);
                    }
                }
            });
                                 
            this.setVisible(true);
        }        
        
        private void setTitleCursor(boolean title) {
            if (title && !isOverTitle && !desktopManager.isDragging()) {
                isOverTitle = true;
                this.setCursor(titleCursor);                        
            }
            else if (!title && isOverTitle) {
                isOverTitle = false;
                this.setCursor(defaultCursor);
            }
        }
        
        @Override
        void minMaxFrame() {
            if (this.isMaximum()) {
                this.setBorder(iframeBorder);
                desktopManager.minimizeFrame(this);
                this.isMaximum = false;
            }
            else {
                this.setBorder(emptyBorder);
                desktopManager.maximizeFrame(this);
                this.isMaximum = true;
            }
        }
    }
    
    private final class Frame3DBack extends InternalFrame3D {

        private Frame3DBack(Canvas3D canvas, Vp vp) {
            super(canvas, vp);
            
            this.setBorder(BorderFactory.createEmptyBorder()); 
            
            // PopupMenu
            canvas.addMouseListener(new MouseAdapter() { 
                @Override
                public void mouseClicked(MouseEvent event) {
                    if (SwingUtilities.isRightMouseButton(event)) {
                        PopupMenu3D menu = new PopupMenu3D(Frame3DBack.this);
                        menu.show(Frame3DBack.this, event.getX()+3, event.getY()+3);
                    }
                }
            });
            
            this.setVisible(true);
        }
        
        // Isn't selectable
        @Override
        public void setSelected(boolean selected) {           
        }
    }
    
    private final class DesktopManager3D extends DefaultDesktopManager {
        
        private boolean isDragged = false;
        private boolean isResized = false;
        
        private DesktopManager3D() {
        }
        
        // Dragging
        
        boolean isDragging() {
            return isDragged;
        }
        
        @Override
        public void beginDraggingFrame(JComponent frame) {
        	
        	universe.startStopRepainter(true);
            
            if (frame instanceof Frame3D)
                universe.setNavigatorEnable(false, ((Frame3D)frame).getVp());
            
            if (currDragMode == JDesktopPane.OUTLINE_DRAG_MODE) {
                outlinePanels.setOutline(frame.getBounds());
                outlinePanels.setVisible(true);
            }
            
            super.beginDraggingFrame(frame);
        }
        @Override
        public void dragFrame(JComponent frame, int newX, int newY) {
          
            // Keep frame within the area of desktop
            if (newX < 0) {
                newX = 0;
            }
            else {
                if (newX + frame.getWidth() > jDesktopPane.getWidth()) {
                    newX = jDesktopPane.getWidth() - frame.getWidth();
                }
            }
            
            if (newY < 0) {
                newY = 0;
            }
            else {
                if (newY + frame.getHeight() > jDesktopPane.getHeight()) {
                    newY = jDesktopPane.getHeight() - frame.getHeight();
                }
            }
            
            if (currDragMode == JDesktopPane.OUTLINE_DRAG_MODE) {
                outlinePanels.setOutline(newX, newY, frame.getWidth(), frame.getHeight());
            }
            
            super.dragFrame(frame, newX, newY);
          
            isDragged = true;
        }
        @Override
        public void endDraggingFrame(JComponent frame) {
            
            if (frame instanceof Frame3D)
                universe.setNavigatorEnable(true, ((Frame3D)frame).getVp());
            
            if (currDragMode == JDesktopPane.OUTLINE_DRAG_MODE) {
                outlinePanels.setVisible(false);
            }
            
            super.endDraggingFrame(frame);
            
            if (isDragged && (frame instanceof Frame3D))
                layoutGroup.select(null);
            
            isDragged = false;
            
            universe.startStopRepainter(false);
            fpsResetTimer.start();
        }
        
        // Resizing
        
        @Override
        public void beginResizingFrame(JComponent frame, int direction) {
        	
        	universe.startStopRepainter(true);

            if (currDragMode == JDesktopPane.OUTLINE_DRAG_MODE) {
                outlinePanels.setOutline(frame.getBounds());
                outlinePanels.setVisible(true);
            }
            
            super.beginResizingFrame(frame, direction);
        }
        @Override
        public void resizeFrame(JComponent frame, int newX, int newY, 
                                                  int newWidth, int newHeight) {
            if (currDragMode == JDesktopPane.OUTLINE_DRAG_MODE) {
                outlinePanels.setOutline(newX, newY, newWidth, newHeight);
            }        
            
            super.resizeFrame(frame, newX, newY, newWidth, newHeight);
            
            isResized = true;
        }
        @Override
        public void endResizingFrame(JComponent frame) {
        
            if (currDragMode == JDesktopPane.OUTLINE_DRAG_MODE) {
                outlinePanels.setVisible(false);
            }        
            
            super.endResizingFrame(frame);
            
            if (isResized && (frame instanceof Frame3D))
                layoutGroup.select(null);
            
            isResized = false;
            
            universe.startStopRepainter(false);
            fpsResetTimer.start();
        }
                
        @Override
        public void maximizeFrame(JInternalFrame frame) {
                        
            super.maximizeFrame(frame);
            
            for (InternalFrame3D iFrame : iFrame3Ds) {
                if (frame != iFrame) {
                    iFrame.canvas.stopRenderer(); // Stop Java 3D rendering
                }
            }            
            
            layoutGroup.setLabelsEnabled(false);
        }
        @Override
        public void minimizeFrame(JInternalFrame frame) {
            
            for (InternalFrame3D iFrame : iFrame3Ds) {
                if (frame != iFrame) {
                    iFrame.canvas.startRenderer(); // Start Java 3D rendering
                }
            }
            
            super.minimizeFrame(frame);
            
            layoutGroup.setLabelsEnabled(true);
        }
    }
    
    // Slider
    
    // Transparent !!
    private class Slider extends JSlider {       
        
        private ChangeListener listener = null;
        
        private Slider(int min, int max, int value, Dimension preferredSize) {
            super(min, max, value);
            setOpaque(false);
            setForeground(fgColor);
            setAlignmentX(JPanel.CENTER_ALIGNMENT);
            setBorder(BorderFactory.createEmptyBorder());
            setPreferredSize(preferredSize);
            
            listener = new ChangeListener() {
                public void stateChanged(ChangeEvent event) {
                    valueChanged(Slider.this.getValue());
                }
            };            
            addChangeListener(listener);
        }
        
        private void setAtValue(int value) {
            this.removeChangeListener(listener);
            this.setValue(value);
            this.addChangeListener(listener);
        }
        
        void valueChanged(int value) {           
        }
    }
    
    // Transparent !!
    private class YPanel extends JPanel {
        private YPanel() {
            setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
            setOpaque(false);
            setAlignmentX(JPanel.CENTER_ALIGNMENT);
        }
    }

    // Transparent by default
    private class Label extends JLabel {
        
        private boolean isEnabled = true;
        private boolean isPressed = false;
        private boolean isSelected = false;
        
        private Label(String text) {
            this(text, null);
        }
        
        private Label(String text, String tip) {
            super(text);
            if (tip != null)
                this.setToolTipText(tip);
            setFont(textFont);
            setForeground(fgColor);
            setAlignmentX(JPanel.CENTER_ALIGNMENT);
        }
        
        boolean isLabelEnabled() {
            return isEnabled;
        }
        void setLabelEnabled(boolean enable) {
            isEnabled = enable;
        }
        
        boolean isPressed() {
            return isPressed; 
        }
        void setPressed(boolean press) {
            isPressed = press;
        }
        
        boolean isSelected() {
            return isSelected; 
        }       
        void setSelected(boolean select) {
            isSelected = select;
        }
    }
    
    // Button / RadioButton
    
    //
    // Button / -Group
    //
    // Used in a ButtonGroup
    private class ButtonLabel extends Label {
    
        private ButtonLabel(String text) {
            this(text, 0, 0, 0, 0, null);
        }
        private ButtonLabel(String text, String tip) {
            this(text, 0, 0, 0, 0, tip);
        }
        private ButtonLabel(String text, int t, int l, int b, int r, String tip) {
            super(text, tip);
            setBorder(BorderFactory.createEmptyBorder(t, l, b, r));           
        }
        
        void setTextTip(String text, String tip) {
            if (text != null)
                this.setText(text);
            if (tip != null)
                this.setToolTipText(tip);            
        }
    }
    
    // Individual button
    private abstract class SingleButtonLabel extends ButtonLabel {
        
        private SingleButtonLabel(String text) {
            this(text, 0, 0, 0, 0, null);
        }
        private SingleButtonLabel(String text, String tip) {
            this(text, 0, 0, 0, 0, tip);
        }
        private SingleButtonLabel(String text, int t, int l, int b, int r, String tip) {
            super(text, t, l, b, r, tip);
            
            addMouseListener(new MouseAdapter() { 

                public void mouseEntered(MouseEvent event) {
                    ButtonLabel button = (ButtonLabel)event.getSource();
                    if (!button.isPressed())
                        button.setForeground(enterColor);
                }
                public void mouseExited(MouseEvent event) {
                    ButtonLabel button = (ButtonLabel)event.getSource();
                    if (!button.isPressed())
                        button.setForeground(fgColor);
                }
                public void mousePressed(MouseEvent event) {
                    ButtonLabel button = (ButtonLabel)event.getSource();
                    button.setPressed(true);
                    button.setForeground(pressColor);
                }
                public void mouseReleased(MouseEvent event) {
                    ButtonLabel button = (ButtonLabel)event.getSource();
                    button.setPressed(false);
                    if (button.contains(event.getX(), event.getY())) {
                        button.setForeground(enterColor);                                  
                        action();
                    }
                    else
                        button.setForeground(fgColor);
                }
            });
        }
    
        void action() {           
        }
    }
    
    //
    // RadioButton / -Group
    //   
    private final class RadioLabel extends Label {
        
        private RadioLabel(String text) {
            this(text, 0, 0, 0, 0, null);
        }
        private RadioLabel(String text, int t, int l, int b, int r, String tip) {
            super(text);
            setBorder(BorderFactory.createEmptyBorder(t, l, b, r));    
            if (tip != null)
                this.setToolTipText(tip);
        }
    }
    
    private abstract class RadioLabelGroup {
        
        // RadioLabels of this group 
        private ArrayList<RadioLabel> radioList = null;
        
        // Single listener for all RadioLabels
        private MouseAdapter actionListener = null;
        
        private RadioLabelGroup() {
                       
            radioList = new ArrayList<RadioLabel>();
            
            actionListener = new MouseAdapter() { 
                               
                @Override
                public void mouseEntered(MouseEvent event) {
                    RadioLabel radio = (RadioLabel)event.getSource();
                    if (radio.isLabelEnabled() &&
                        !radio.isPressed() && !radio.isSelected())
                        radio.setForeground(enterColor);
                }
                @Override
                public void mouseExited(MouseEvent event) {
                    RadioLabel radio = (RadioLabel)event.getSource();
                    if (radio.isLabelEnabled() &&
                        !radio.isPressed() && !radio.isSelected())
                        radio.setForeground(fgColor);
                }
                @Override
                public void mousePressed(MouseEvent event) {
                    RadioLabel radio = (RadioLabel)event.getSource();
                    if (radio.isLabelEnabled() && !radio.isSelected()) {
                        radio.setPressed(true);
                        radio.setForeground(pressColor);
                    }
                }
                @Override
                public void mouseReleased(MouseEvent event) {
                    RadioLabel radio = (RadioLabel)event.getSource();
                    
                    if (!radio.isLabelEnabled() || radio.isSelected())
                        return;
                    
                    radio.setPressed(false);
                    if (radio.contains(event.getX(), event.getY())) {
                         select(radio);
                    }
                    else {
                        radio.setForeground(fgColor);
                    }
                }
            };
        }
        
        private void add(RadioLabel radio) {
            radioList.add(radio);
            radio.addMouseListener(actionListener);
        }
        
        private void setSelection(RadioLabel radio) {
            for (RadioLabel rl : radioList) {
                rl.setSelected(false);
                rl.setForeground(fgColor);
            }
            
            if (radio != null) {
                radio.setSelected(true);
                radio.setForeground(selectColor);
            }
        }
        
        private void select(RadioLabel radio) {
            setSelection(radio);
            selectionChanged(radio);
        }
        
        private void setLabelsEnabled(boolean enable) {
            for (RadioLabel rl : radioList) {
                rl.setLabelEnabled(enable);
                if (enable) {
                    if (rl.isSelected())
                        rl.setForeground(selectColor);
                    else
                        rl.setForeground(fgColor);
                }
                else
                    rl.setForeground(disabledColor);
            }
        }
        
        // To be implemented by subclasses
        abstract void selectionChanged(RadioLabel radio);
    }   
    
    private final class PopupMenu3D extends JPopupMenu {
        
        private PopupMenu3D(final InternalFrame3D iFrame3D) {
            
            if (iFrame3D.isMaximizable()) {
                String minmax = "Maximize";
                if (iFrame3D.isMaximum())
                    minmax = "Minimize";
            
                JMenuItem jMenuItemMinMax = new JMenuItem(minmax);
                jMenuItemMinMax.setFont(textFont);
                jMenuItemMinMax.addActionListener(new ActionListener() {
                    public void actionPerformed(ActionEvent event) {
                        iFrame3D.minMaxFrame();
                    }                
                });
                
                this.add(jMenuItemMinMax);            
            }
            
            JMenuItem jMenuItemVP = new JMenuItem("Viewpoint");
            jMenuItemVP.setFont(textFont);
            jMenuItemVP.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent event) {
                    universe.setVantagePoint(iFrame3D.vp);
                }                
            });            
            this.add(jMenuItemVP);
            
            // If application
            if (!isApplet) {
            
                this.addSeparator();
                           
                String frame = "Full screen";
                if (isFullScreen)
                    frame = "Window";                
                JMenuItem jMenuItemFrame = new JMenuItem(frame);
                jMenuItemFrame.setFont(textFont);
                jMenuItemFrame.addActionListener(new ActionListener() {
                    public void actionPerformed(ActionEvent event) {
                        toggleFrame(!isFullScreen);
                    }                
                });            
                this.add(jMenuItemFrame);
                
                this.addSeparator();
                
                JMenuItem jMenuItemExit = new JMenuItem("Exit");
                jMenuItemExit.setFont(textFont);
                jMenuItemExit.addActionListener(new ActionListener() {
                    public void actionPerformed(ActionEvent event) {
                        jFrame.dispose();
                        jFrameFull.dispose();
                        universe.closeUniverse();
                        System.exit(0);
                    }                
                });            
                this.add(jMenuItemExit);
            }
        }
    }
    
    //
    // Outlines
    //
    
    // 4 panels, one for each line
    private final class OutlinePanels {
        
        private JPanel northLine = new JPanel();
        private JPanel southLine = new JPanel();
        private JPanel westLine  = new JPanel();
        private JPanel eastLine  = new JPanel();
        
        private Color lineColor = Color.DARK_GRAY;
        
        private int lineWidth = 2;
        
        private OutlinePanels() {
            northLine.setBackground(lineColor);
            eastLine.setBackground(lineColor);
            southLine.setBackground(lineColor);
            westLine.setBackground(lineColor);     
            
            setVisible(false);
        }
        
        private void setOutline(int x, int y, int width, int height) {
            
            northLine.setBounds(x, y, width, lineWidth);
            southLine.setBounds(x, y+height-lineWidth, width, lineWidth);
            
            eastLine.setBounds(x+width-lineWidth, y, lineWidth, height);
            westLine.setBounds(x, y, lineWidth, height);
        }
       
        private void setOutline(Rectangle bounds) {
            
            northLine.setBounds(bounds.x, bounds.y, bounds.width, lineWidth);
            southLine.setBounds(bounds.x, bounds.y+bounds.height-lineWidth, bounds.width, lineWidth);
            
            eastLine.setBounds(bounds.x+bounds.width-lineWidth, bounds.y, lineWidth, bounds.height);
            westLine.setBounds(bounds.x, bounds.y, lineWidth, bounds.height);
        }
                
        private void setVisible(boolean show) {
            northLine.setVisible(show);
            eastLine.setVisible(show);
            southLine.setVisible(show);
            westLine.setVisible(show);            
        }
    }
    
}
