package org.interactivemesh.scala.j3d.samples.distortstring

// Java
import java.awt.{Dimension, Point, Toolkit}
// Scala Swing
import scala.swing.{Applet, Frame, Label, Reactor, RichWindow, SwingApplication, Swing}

/*
 * DistortStringApp.scala
 *
 * Version: 1.2
 * Date: 2011/05/26
 *
 * Copyright (c) 2010-2011
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'DistortStringApp.scala'.
 *
 */

// Application trait
trait App {
  // System properties
  private[distortstring] def printSystemProps {
	println("")
    println("Scala DistortString : Copyright (c) 2010-2011 August Lammersdorf, www.InteractiveMesh.com.")
    println("")
    println("------------------------------------------------------------------------")
    println("SYSTEM  PROPERTIES")
    println("------------------------------------------------------------------------")
    println("OS Name  =  " + System.getProperty("os.name"))
    println("OS Arch  =  " + System.getProperty("os.arch"))
    println("OS Version  =  " + System.getProperty("os.version"))
    println("------------------------------------------------------------------------")
    println("Java Version  =  " + System.getProperty("java.version"))
    println("Java Vender  =  " + System.getProperty("java.vendor"))
    println("------------------------------------------------------------------------")
  }	
}

//
// Java Web Start
//
object DistortStringFrame extends SwingApplication {
	
  private val screenSize = Toolkit.getDefaultToolkit.getScreenSize	
 
  private var appPanel: DistortStringPanel = null
 
  private[distortstring] object FrameMode extends Enumeration {
    type FrameMode = Value
    val Fullscreen = Value("Fullscreen")
    val Windowed = Value("Windowed")
    
    def opposite(m: FrameMode) = if (m eq Fullscreen) Windowed else Fullscreen
  }
	
  import FrameMode._
	  
  private var frameMode = Windowed
  
  private[distortstring] trait FrameApp extends App {	  
    val mode: FrameMode
    def switchAppFrame = switchFrame(FrameMode.opposite(mode))
    def closeApp = closeAppOperation
  }
  
  // Windowed
  private object mainFrame extends Frame with FrameApp { // derived from ... Window with RootPanel

    title = "InteractiveMesh : Scala DistortString"  
    	
    override val mode = Windowed
	
    // Frame size and location
	private val frameHeight = (screenSize.height * 0.8).asInstanceOf[Int]
	private val frameWidth = Math.min((frameHeight * 1.4).asInstanceOf[Int], screenSize.width)
	preferredSize = new Dimension(frameWidth, frameHeight)
	location = new Point((screenSize.width - frameWidth)/2, (screenSize.height - frameHeight)/2)

    override def closeOperation() {
      closeAppOperation
    }
  }
  
  // Fullscreen
  private object fullFrame extends Frame with RichWindow.Undecorated with FrameApp {
	  
    override val mode = Fullscreen
	
    // Frame size and location
    preferredSize = screenSize 
    location = new Point(0, 0)
	
    override def closeOperation() {
      closeAppOperation
    }
  }

  private def switchFrame(m: FrameMode) {
    m match {
      case Fullscreen if frameMode eq Windowed =>
        mainFrame.visible = false
        mainFrame.contents = new Label
        
        appPanel.frame = fullFrame
        
        fullFrame.contents = appPanel
        fullFrame.visible = true
        
      case Windowed if frameMode eq Fullscreen =>
        fullFrame.visible = false
        fullFrame.contents = new Label
        
        appPanel.frame = mainFrame
        
        mainFrame.contents = appPanel
        mainFrame.visible = true        
    }
    frameMode = m
  }
		
  // Called in 'main' on EDT
  override def startup(args: Array[String]) {

    // Application panel
    appPanel = new DistortStringPanel(
      mainFrame.peer.getGraphicsConfiguration.getDevice,
      screenSize,
      mainFrame
    )

    mainFrame.contents = appPanel
    mainFrame.pack
    mainFrame.visible = true
    
    fullFrame.pack
    fullFrame.visible = false
  }
      
  // Shutdown
  private def closeAppOperation {
    mainFrame.visible = false
    fullFrame.visible = false
    appPanel.closePanel
    mainFrame.dispose
    fullFrame.dispose
    System.exit(0)
  }
}

//
// JApplet
//
final class DistortStringApplet extends Applet {    // Info: Applet extends javax.swing.JApplet
	
  // Why not implemented in Applet ?
  override def destroy() { ui.destroy() }

  object ui extends UI with Reactor with App {     // Info: UI extends RootPanel
	  								   			   //       ui.peer = DistortStringApplet.this
    private val screenSize = toolkit.getScreenSize	
    private var panel: DistortStringPanel = null
    
    def init() = {
      Swing.onEDT({
        // Application panel
        panel = new DistortStringPanel(
          peer.getGraphicsConfiguration.getDevice, 
          screenSize,
          ui)
        ui.contents = panel
      })
    }
    
    override def start() {  
    }
     
    override def stop() {
    }
     
    def destroy() {
	  panel.closePanel
    }
  }
}
