package com.interactivemesh.j3d.testspace.awtshape;

import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;

import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Group;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Locale;
import javax.media.j3d.Material;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;

import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;

import com.interactivemesh.j3d.community.utils.geometry.AWTShapeExtruder;
import com.interactivemesh.j3d.community.utils.geometry.AWTShapeExtrusion;
import com.interactivemesh.j3d.community.utils.geometry.String3D;

import static com.interactivemesh.j3d.community.utils.geometry.String3D.Alignment.*;
import static com.interactivemesh.j3d.community.utils.geometry.String3D.Path.*;

import com.interactivemesh.j3d.community.utils.navigation.orbit.OrbitBehaviorInterim;

/*
 * String3DAlignments
 * 
 * Author: August Lammersdorf, www.InteractiveMesh.com/org
 * Version: 1.0
 * Date: 2008/11/17 
 * 
 * Please create your own implementation.
 * You are allowed to copy all lines you like of this source code, 
 * but you may not modify, compile, or distribute this 'String3DAlignments'. 
 *
*/

public class String3DAlignments {
    
    static {
        System.out.println("String3DAlignments: Copyright (c) 2008 August Lammersdorf, www.InteractiveMesh.com.");
    }

    private BoundingSphere          globalBounds    =   null;

    private Canvas3D                canvas3D        =   null;
    private Locale                  locale          =   null;

    private BranchGroup             sceneBranch     =   null;
    private BranchGroup             viewBranch      =   null;
    private BranchGroup             enviBranch      =   null;

    private OrbitBehaviorInterim    orbitBehInterim =   null;
    
    String3DAlignments() {

        createUniverse();
        createScene();
        setLive();

        // Setup navigation

        float sceneRadius = 1.0f;

        Bounds bounds = sceneBranch.getBounds();
        BoundingSphere sphereBounds = null; 

        if (bounds.isEmpty()) {
            sphereBounds = new BoundingSphere(); 
        }
        else {
            if (sphereBounds instanceof BoundingSphere)
                sphereBounds = (BoundingSphere)sceneBranch.getBounds();
            else
                sphereBounds = new BoundingSphere(sceneBranch.getBounds());

            sceneRadius = (float)sphereBounds.getRadius();
        }
        
        orbitBehInterim.setProjectionMode(View.PARALLEL_PROJECTION);
        
        orbitBehInterim.setTransFactors(sceneRadius/2.0f, sceneRadius/2.0f);
        orbitBehInterim.setZoomFactor(sceneRadius/2.0f);
        orbitBehInterim.setRotFactors(0.75f, 0.75f);

        orbitBehInterim.setClippingBounds(sphereBounds);

        orbitBehInterim.goHome(true);
    }

    Canvas3D getCanvas3D() {
        return canvas3D;
    }

    private void createScene() {
        
        // Appearance : dot     
        Appearance dotAppear = new Appearance();
        Material dotMat = new Material();
        dotMat.setAmbientColor(0.0f, 0.0f, 0.0f);
        dotMat.setDiffuseColor(0.0f, 0.6f, 0.0f);
        dotMat.setEmissiveColor(0.0f, 0.4f, 0.0f);
        dotMat.setSpecularColor(0.0f, 0.0f, 0.0f);
        dotAppear.setMaterial(dotMat);
        
        // Appearance : line     
        Appearance lineAppear = new Appearance();
        ColoringAttributes lineColAttr = new ColoringAttributes();
        lineColAttr.setColor(0.0f, 1.0f, 0.0f);
        lineAppear.setColoringAttributes(lineColAttr);
        LineAttributes lineLineAttr = new LineAttributes();
        lineLineAttr.setLinePattern(LineAttributes.PATTERN_DASH);
        lineAppear.setLineAttributes(lineLineAttr);
        
        // Appearance : strings     
        Appearance appear = new Appearance();
        Material mat = new Material();
        mat.setAmbientColor(0.0f, 0.0f, 0.0f);
        mat.setDiffuseColor(0.7f, 0.0f, 0.0f);
        mat.setEmissiveColor(0.3f, 0.0f, 0.0f);
        mat.setSpecularColor(0.0f, 0.7f, 0.04f);
        mat.setShininess(8.0f);
        appear.setMaterial(mat);
        
        //
        // String3D Factories 
        //
        
        AWTShapeExtrusion   extrusion   =   new AWTShapeExtrusion(20); 
        AWTShapeExtruder    extruder    =   new AWTShapeExtruder(0.1, extrusion, Math.toRadians(15));
        
        Font font = new Font("Dialog", Font.PLAIN, 100);
        
        String3D string3D = new String3D(font, extruder);
                
        GeometryArray geom = null;
        Shape3D string3DShape = null;
        
        
        AWTShapeExtrusion   extrusionDot   =   new AWTShapeExtrusion(25); 
        AWTShapeExtruder    extruderDot    =   new AWTShapeExtruder(0.1, extrusionDot, Math.toRadians(15));
        
        Font dotFont = new Font("Dialog", Font.PLAIN, 100);
        
        String3D dot3D = new String3D(dotFont, extruderDot);
        dot3D.setAlignment(CENTER);
        dot3D.setPath(UP_CENTER);
        
        
        // String3Ds Group
        Group string3DGroup = new Group();
        
        //
        // Alignment CENTER
        //
        
        string3D.setPosition(new Point3f(0, 50, 0));        
        string3D.setAlignment(CENTER);
        string3D.setPath(RIGHT);
        
        string3D.setCharacterSpacing(15f);

        geom = string3D.getStringGeometry("Alignment.CENTER");       
        string3DShape = new Shape3D(geom, appear);    

        string3DGroup.addChild(string3DShape);
        
        
        string3D.setCharacterSpacing(0f);
        
        addAlignmentCenter(string3D, dot3D, appear, dotAppear,lineAppear, string3DGroup);       
        
        //
        // Alignment FIRST
        //
        
        string3D.setPosition(new Point3f(-1500, 50, 0));        
        string3D.setAlignment(CENTER);
        string3D.setPath(RIGHT);
        
        string3D.setCharacterSpacing(15f);

        geom = string3D.getStringGeometry("Alignment.FIRST");       
        string3DShape = new Shape3D(geom, appear);    

        string3DGroup.addChild(string3DShape);
        
        
        string3D.setAlignment(FIRST);
        string3D.setCharacterSpacing(0f);
               
        addAlignmentFirst(string3D, dot3D, appear, dotAppear,lineAppear, string3DGroup, -1500);

        //
        // Alignment LAST
        //
        
        string3D.setPosition(new Point3f(1500, 50, 0));        
        string3D.setAlignment(CENTER);
        string3D.setPath(RIGHT);
        
        string3D.setCharacterSpacing(15f);

        geom = string3D.getStringGeometry("Alignment.LAST");       
        string3DShape = new Shape3D(geom, appear);    

        string3DGroup.addChild(string3DShape);
        
        
        string3D.setAlignment(LAST);
        string3D.setCharacterSpacing(0f);
               
        addAlignmentLast(string3D, dot3D, appear, dotAppear,lineAppear, string3DGroup, 1500);


        sceneBranch.addChild(string3DGroup);
               
    }
    
    private void addAlignmentCenter(
                String3D string3D, String3D dot3D,             
                Appearance appear, Appearance dotAppear, Appearance lineAppear, 
                Group string3DGroup) {
        
        GeometryArray geom = null;
        Shape3D string3DShape = null;

        GeometryArray dotGeom = null;
        Shape3D dotShape = null;

        LineArray lineGeom = null;
        float[] lineCoords = null;
        

        // String3D.Path.RIGHT
        string3D.setPosition(new Point3f(0, -150, 0));        
        string3D.setPath(RIGHT);

        geom = string3D.getStringGeometry("Path.RIGHT");        
        string3DShape = new Shape3D(geom, appear);    

        string3DGroup.addChild(string3DShape);
        
        dot3D.setPosition(new Point3f(0, -150, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);
        
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{-550, -150, 0, 550, -150, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));

        
        // String3D.Path.LEFT
        string3D.setPosition(new Point3f(0, -300, 0));        
        string3D.setPath(LEFT);

        geom = string3D.getStringGeometry("Path.LEFT");        
        string3DShape = new Shape3D(geom, appear);    

        string3DGroup.addChild(string3DShape);
        
        dot3D.setPosition(new Point3f(0, -300, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);

        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{-550, -300, 0, 550, -300, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));

        
        // String3D.Path.UP_  position line
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{-300, -1000, 0, 300, -1000, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));

        // String3D.Path.UP_RIGHT
        string3D.setPosition(new Point3f(-200, -1000, 0));        
        string3D.setPath(UP_RIGHT);

        geom = string3D.getStringGeometry("Path.UP RIGHT");        
        string3DShape = new Shape3D(geom, appear);    

        string3DGroup.addChild(string3DShape);
  
        dot3D.setPosition(new Point3f(-200, -1000, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);

        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{-200, -400, 0, -200, -1600, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));

        // String3D.Path.UP_CENTER
        string3D.setPosition(new Point3f(0, -1000, 0));        
        string3D.setPath(UP_CENTER);
        
        geom = string3D.getStringGeometry("Path.UP CENTER");        
        string3DShape = new Shape3D(geom, appear);    

        string3DGroup.addChild(string3DShape);

        dot3D.setPosition(new Point3f(0, -1000, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);

        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{0, -400, 0, 0, -1600, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));

        
        // String3D.Path.UP_LEFT
        string3D.setPosition(new Point3f(200, -1000, 0));        
        string3D.setPath(UP_LEFT);

        geom = string3D.getStringGeometry("Path.UP LEFT");        
        string3DShape = new Shape3D(geom, appear);    

        string3DGroup.addChild(string3DShape);

        dot3D.setPosition(new Point3f(200, -1000, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);

        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{200, -400, 0, 200, -1600, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));

        
        // String3D.Path.DOWN_  position line
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{-300, -2300, 0, 300, -2300, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));

        // String3D.Path.DOWN_RIGHT
        string3D.setPosition(new Point3f(-200, -2300, 0));        
        string3D.setPath(DOWN_RIGHT);

        geom = string3D.getStringGeometry("Path.DOWN RIGHT");        
        string3DShape = new Shape3D(geom, appear);    

        string3DGroup.addChild(string3DShape);

        dot3D.setPosition(new Point3f(-200, -2300, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);

        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{-200, -1650, 0, -200, -2950, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));

        
        // String3D.Path.DOWN_CENTER
        string3D.setPosition(new Point3f(0, -2300, 0));        
        string3D.setPath(DOWN_CENTER);

        geom = string3D.getStringGeometry("Path.DOWN CENTER");        
        string3DShape = new Shape3D(geom, appear);    

        string3DGroup.addChild(string3DShape);

        dot3D.setPosition(new Point3f(0, -2300, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);

        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{0, -1650, 0, 0, -2950, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));

        
        // String3D.Path.DOWN_LEFT
        string3D.setPosition(new Point3f(200, -2300, 0));        
        string3D.setPath(DOWN_LEFT);

        geom = string3D.getStringGeometry("Path.DOWN LEFT");        
        string3DShape = new Shape3D(geom, appear);    

        string3DGroup.addChild(string3DShape);

        dot3D.setPosition(new Point3f(200, -2300, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);
        
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{200, -1650, 0, 200, -2950, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));
        
    }
    
    private void addAlignmentFirst(
                String3D string3D, String3D dot3D,             
                Appearance appear, Appearance dotAppear, Appearance lineAppear, 
                Group string3DGroup, int xOffset) {
        
        GeometryArray geom = null;
        Shape3D string3DShape = null;
    
        GeometryArray dotGeom = null;
        Shape3D dotShape = null;
    
        LineArray lineGeom = null;
        float[] lineCoords = null;
        
    
        // String3D.Path.RIGHT
        string3D.setPosition(new Point3f(0 + xOffset, -150, 0));        
        string3D.setPath(RIGHT);
    
        geom = string3D.getStringGeometry("Path.RIGHT");        
        string3DShape = new Shape3D(geom, appear);    
    
        string3DGroup.addChild(string3DShape);
        
        dot3D.setPosition(new Point3f(0 + xOffset, -150, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);
        
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{-550 + xOffset, -150, 0, 550 + xOffset, -150, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));
    
        
        // String3D.Path.LEFT
        string3D.setPosition(new Point3f(0 + xOffset, -300, 0));        
        string3D.setPath(LEFT);
    
        geom = string3D.getStringGeometry("Path.LEFT");        
        string3DShape = new Shape3D(geom, appear);    
    
        string3DGroup.addChild(string3DShape);
        
        dot3D.setPosition(new Point3f(0 + xOffset, -300, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);
    
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{-550 + xOffset, -300, 0, 550 + xOffset, -300, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));
    
        
        // String3D.Path.UP_  position line
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{-300 + xOffset, -1500, 0, 300 + xOffset, -1500, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));

        // String3D.Path.UP_RIGHT
        string3D.setPosition(new Point3f(-200 + xOffset, -1500, 0));        
        string3D.setPath(UP_RIGHT);
    
        geom = string3D.getStringGeometry("Path.UP RIGHT");        
        string3DShape = new Shape3D(geom, appear);    
    
        string3DGroup.addChild(string3DShape);
    
        dot3D.setPosition(new Point3f(-200 + xOffset, -1500, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);
    
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{-200 + xOffset, -400, 0, -200 + xOffset, -1600, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));
    
        
        // String3D.Path.UP_CENTER
        string3D.setPosition(new Point3f(0 + xOffset, -1500, 0));        
        string3D.setPath(UP_CENTER);
    
        geom = string3D.getStringGeometry("Path.UP CENTER");        
        string3DShape = new Shape3D(geom, appear);    
    
        string3DGroup.addChild(string3DShape);
    
        dot3D.setPosition(new Point3f(0 + xOffset, -1500, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);
    
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{0 + xOffset, -400, 0, 0 + xOffset, -1600, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));
    
        
        // String3D.Path.UP_LEFT
        string3D.setPosition(new Point3f(200 + xOffset, -1500, 0));        
        string3D.setPath(UP_LEFT);
    
        geom = string3D.getStringGeometry("Path.UP LEFT");        
        string3DShape = new Shape3D(geom, appear);    
    
        string3DGroup.addChild(string3DShape);
    
        dot3D.setPosition(new Point3f(200 + xOffset, -1500, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);
    
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{200 + xOffset, -400, 0, 200 + xOffset, -1600, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));
    
        
        // String3D.Path.DOWN_  position line
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{-300 + xOffset, -1700, 0, 300 + xOffset, -1700, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));

        // String3D.Path.DOWN_RIGHT
        string3D.setPosition(new Point3f(-200 + xOffset, -1700, 0));        
        string3D.setPath(DOWN_RIGHT);
    
        geom = string3D.getStringGeometry("Path.DOWN RIGHT");        
        string3DShape = new Shape3D(geom, appear);    
    
        string3DGroup.addChild(string3DShape);
    
        dot3D.setPosition(new Point3f(-200 + xOffset, -1700, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);
    
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{-200 + xOffset, -1650, 0, -200 + xOffset, -2950, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));
    
        
        // String3D.Path.DOWN_CENTER
        string3D.setPosition(new Point3f(0 + xOffset, -1700, 0));        
        string3D.setPath(DOWN_CENTER);
    
        geom = string3D.getStringGeometry("Path.DOWN CENTER");        
        string3DShape = new Shape3D(geom, appear);    
    
        string3DGroup.addChild(string3DShape);
    
        dot3D.setPosition(new Point3f(0 + xOffset, -1700, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);
    
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{0 + xOffset, -1650, 0, 0 + xOffset, -2950, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));
    
        
        // String3D.Path.DOWN_LEFT
        string3D.setPosition(new Point3f(200 + xOffset, -1700, 0));        
        string3D.setPath(DOWN_LEFT);
    
        geom = string3D.getStringGeometry("Path.DOWN LEFT");        
        string3DShape = new Shape3D(geom, appear);    
    
        string3DGroup.addChild(string3DShape);
    
        dot3D.setPosition(new Point3f(200 + xOffset, -1700, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);
        
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{200 + xOffset, -1650, 0, 200 + xOffset, -2950, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));
        
    }

    private void addAlignmentLast(
                String3D string3D, String3D dot3D,             
                Appearance appear, Appearance dotAppear, Appearance lineAppear, 
                Group string3DGroup, int xOffset) {
        
        GeometryArray geom = null;
        Shape3D string3DShape = null;
    
        GeometryArray dotGeom = null;
        Shape3D dotShape = null;
    
        LineArray lineGeom = null;
        float[] lineCoords = null;
        
    
        // String3D.Path.RIGHT
        string3D.setPosition(new Point3f(0 + xOffset, -150, 0));        
        string3D.setPath(RIGHT);
    
        geom = string3D.getStringGeometry("Path.RIGHT");        
        string3DShape = new Shape3D(geom, appear);    
    
        string3DGroup.addChild(string3DShape);
        
        dot3D.setPosition(new Point3f(0 + xOffset, -150, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);
        
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{-550 + xOffset, -150, 0, 550 + xOffset, -150, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));
    
        
        // String3D.Path.LEFT
        string3D.setPosition(new Point3f(0 + xOffset, -300, 0));        
        string3D.setPath(LEFT);
    
        geom = string3D.getStringGeometry("Path.LEFT");        
        string3DShape = new Shape3D(geom, appear);    
    
        string3DGroup.addChild(string3DShape);
        
        dot3D.setPosition(new Point3f(0 + xOffset, -300, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);
    
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{-550 + xOffset, -300, 0, 550 + xOffset, -300, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));
    
        
        // String3D.Path.UP_  position line
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{-300 + xOffset, -450, 0, 300 + xOffset, -450, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));

        // String3D.Path.UP_RIGHT
        string3D.setPosition(new Point3f(-200 + xOffset, -450, 0));        
        string3D.setPath(UP_RIGHT);
    
        geom = string3D.getStringGeometry("Path.UP RIGHT");        
        string3DShape = new Shape3D(geom, appear);    
    
        string3DGroup.addChild(string3DShape);
    
        dot3D.setPosition(new Point3f(-200 + xOffset, -450, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);
    
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{-200 + xOffset, -400, 0, -200 + xOffset, -1600, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));
    
        
        // String3D.Path.UP_CENTER
        string3D.setPosition(new Point3f(0 + xOffset, -450, 0));        
        string3D.setPath(UP_CENTER);
    
        geom = string3D.getStringGeometry("Path.UP CENTER");        
        string3DShape = new Shape3D(geom, appear);    
    
        string3DGroup.addChild(string3DShape);
    
        dot3D.setPosition(new Point3f(0 + xOffset, -450, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);
    
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{0 + xOffset, -400, 0, 0 + xOffset, -1600, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));
    
        
        // String3D.Path.UP_LEFT
        string3D.setPosition(new Point3f(200 + xOffset, -450, 0));        
        string3D.setPath(UP_LEFT);
    
        geom = string3D.getStringGeometry("Path.UP LEFT");        
        string3DShape = new Shape3D(geom, appear);    
    
        string3DGroup.addChild(string3DShape);
    
        dot3D.setPosition(new Point3f(200 + xOffset, -450, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);
    
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{200 + xOffset, -400, 0, 200 + xOffset, -1600, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));
    
        
        // String3D.Path.DOWN_  position line
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{-300 + xOffset, -2900, 0, 300 + xOffset, -2900, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));

        // String3D.Path.DOWN_RIGHT
        string3D.setPosition(new Point3f(-200 + xOffset, -2900, 0));        
        string3D.setPath(DOWN_RIGHT);
    
        geom = string3D.getStringGeometry("Path.DOWN RIGHT");        
        string3DShape = new Shape3D(geom, appear);    
    
        string3DGroup.addChild(string3DShape);
    
        dot3D.setPosition(new Point3f(-200 + xOffset, -2900, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);
    
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{-200 + xOffset, -1650, 0, -200 + xOffset, -2950, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));
    
        
        // String3D.Path.DOWN_CENTER
        string3D.setPosition(new Point3f(0 + xOffset, -2900, 0));        
        string3D.setPath(DOWN_CENTER);
    
        geom = string3D.getStringGeometry("Path.DOWN CENTER");        
        string3DShape = new Shape3D(geom, appear);    
    
        string3DGroup.addChild(string3DShape);
    
        dot3D.setPosition(new Point3f(0 + xOffset, -2900, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);
    
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{0 + xOffset, -1650, 0, 0 + xOffset, -2950, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));
    
        
        // String3D.Path.DOWN_LEFT
        string3D.setPosition(new Point3f(200 + xOffset, -2900, 0));        
        string3D.setPath(DOWN_LEFT);
    
        geom = string3D.getStringGeometry("Path.DOWN LEFT");        
        string3DShape = new Shape3D(geom, appear);    
    
        string3DGroup.addChild(string3DShape);
    
        dot3D.setPosition(new Point3f(200 + xOffset, -2900, 0));
        dotGeom = dot3D.getStringGeometry("."); ;
        dotShape = new Shape3D(dotGeom, dotAppear);   
        string3DGroup.addChild(dotShape);
        
        lineGeom = new LineArray(2, LineArray.COORDINATES);
        lineCoords = new float[]{200 + xOffset, -1650, 0, 200 + xOffset, -2950, 0};
        lineGeom.setCoordinates(0, lineCoords);
        string3DGroup.addChild(new Shape3D(lineGeom, lineAppear));
        
    }

    private void setLive() {
/*        sceneBranch.compile();
        viewBranch.compile();
        enviBranch.compile();*/
        locale.addBranchGraph(sceneBranch);
        locale.addBranchGraph(viewBranch);
        locale.addBranchGraph(enviBranch);
    }
    
    private void createUniverse() {     
        
        // Bounds
        globalBounds = new BoundingSphere();
        globalBounds.setRadius(Double.MAX_VALUE);  
        
        //
        // Viewing
        //
        View view = new View();
        view.setPhysicalBody(new PhysicalBody());
        view.setPhysicalEnvironment(new PhysicalEnvironment());
        
        GraphicsConfigTemplate3D gCT = new GraphicsConfigTemplate3D();
        GraphicsConfiguration gcfg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration(gCT);
        
        try {
            canvas3D = new Canvas3D(gcfg);
        }
        catch (NullPointerException e) {
            System.out.println("String3DAlignments: Canvas3D failed !!");
            e.printStackTrace();
            System.exit(0);
        }
        catch (IllegalArgumentException e) {
            System.out.println("String3DAlignments: Canvas3D failed !!");
            e.printStackTrace();
            System.exit(0);
        }               
        
        view.addCanvas3D(canvas3D);

        //
        // SuperStructure
        //
        VirtualUniverse vu = new VirtualUniverse();
        locale = new Locale(vu);        
        
        //
        // BranchGraphs
        //      
        sceneBranch = new BranchGroup();
        viewBranch = new BranchGroup();
        enviBranch = new BranchGroup();
        
        // ViewBranch
        
        TransformGroup viewTG = new TransformGroup();
        viewTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
                       
        ViewPlatform vp = new ViewPlatform();
        view.attachViewPlatform(vp);
        
        DirectionalLight headLight = new DirectionalLight();
        headLight.setInfluencingBounds(globalBounds);

        viewTG.addChild(vp);
        viewTG.addChild(headLight);
        
        viewBranch.addChild(viewTG);
        
        // Navigator
        orbitBehInterim = new OrbitBehaviorInterim(canvas3D, viewTG, view, OrbitBehaviorInterim.REVERSE_ALL);
        orbitBehInterim.setSchedulingBounds(globalBounds);
        orbitBehInterim.setClippingEnabled(true);
        Transform3D homeTransform = new Transform3D();
        homeTransform.setTranslation(new Vector3d(0, -1405, 6400));
        orbitBehInterim.setHomeTransform(homeTransform);        
        orbitBehInterim.setHomeRotationCenter(new Point3d(0, -1405, 0));

        viewTG.addChild(orbitBehInterim);       
        
        // EnviBranch
        
        Background bg = new Background();
        bg.setApplicationBounds(globalBounds);
        bg.setColor(0.2f, 0.4f, 1.0f);
        
        enviBranch.addChild(bg);
    }
}
