package com.interactivemesh.j3d.testspace.awtshape;

import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;

import java.awt.geom.GeneralPath;

import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Locale;
import javax.media.j3d.Material;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;

import com.interactivemesh.j3d.community.utils.geometry.AWTShapeExtruder;
import com.interactivemesh.j3d.community.utils.geometry.AWTShapeExtrusion;
import com.interactivemesh.j3d.community.utils.geometry.String3D;

import static com.interactivemesh.j3d.community.utils.geometry.String3D.Alignment.*;
import static com.interactivemesh.j3d.community.utils.geometry.String3D.Path.*;

import com.interactivemesh.j3d.community.utils.navigation.orbit.OrbitBehaviorInterim;


/*
 * String3DFan
 * 
 * Author: August Lammersdorf, www.InteractiveMesh.com/org
 * Version: 1.0
 * Date: 2008/11/17 
 * 
 * Please create your own implementation.
 * You are allowed to copy all lines you like of this source code, 
 * but you may not modify, compile, or distribute this 'String3DFan'. 
 *
*/

final class String3DFan {
    
    static {
        System.out.println("String3DFan: Copyright (c) 2008 August Lammersdorf, www.InteractiveMesh.com.");
    }

    private BoundingSphere          globalBounds    =   null;

    private Canvas3D                canvas3D        =   null;
    private Locale                  locale          =   null;

    private BranchGroup             sceneBranch     =   null;
    private BranchGroup             viewBranch      =   null;
    private BranchGroup             enviBranch      =   null;

    private OrbitBehaviorInterim    orbitBehInterim =   null;
    
    String3DFan() {

        createUniverse();
        createScene();
        setLive();

        // Setup navigation

        float sceneRadius = 1.0f;

        Bounds bounds = sceneBranch.getBounds();
        BoundingSphere sphereBounds = null; 

        if (bounds.isEmpty()) {
            sphereBounds = new BoundingSphere(); 
        }
        else {
            if (sphereBounds instanceof BoundingSphere)
                sphereBounds = (BoundingSphere)sceneBranch.getBounds();
            else
                sphereBounds = new BoundingSphere(sceneBranch.getBounds());

            sceneRadius = (float)sphereBounds.getRadius();
        }

        orbitBehInterim.setTransFactors(sceneRadius/2.0f, sceneRadius/2.0f);
        orbitBehInterim.setZoomFactor(sceneRadius/2.0f);
        orbitBehInterim.setRotFactors(0.75f, 0.75f);

        orbitBehInterim.setClippingBounds(sphereBounds);

        orbitBehInterim.goHome(true);
    }

    Canvas3D getCanvas3D() {
        return canvas3D;
    }

    private void createScene() {

        //
        // Appearance: Material
        //
        Appearance appear3d = new Appearance();
        appear3d.setName("Appear 3D");
        Material mat3d = new Material();
        mat3d.setName("Mat 3D");
        mat3d.setAmbientColor(0.0f, 0.0f, 0.0f);
        mat3d.setDiffuseColor(0.6f, 0.0f, 0.0f);
        mat3d.setEmissiveColor(0.4f, 0.0f, 0.0f);
        mat3d.setSpecularColor(0.0f, 0.0f, 0.0f);
        appear3d.setMaterial(mat3d);

        Appearance[] appears = new Appearance[6];
        
        appears[0] = new Appearance();
        appears[0].setName("Appear SSS");
        Material mat0 = new Material();
        mat0.setName("Mat SSS");
        mat0.setAmbientColor(0.0f, 0.0f, 0.0f);
        mat0.setDiffuseColor(0.6f, 0.0f, 0.0f);
        mat0.setEmissiveColor(0.4f, 0.0f, 0.0f);
        mat0.setSpecularColor(0.0f, 0.0f, 0.0f);
        appears[0].setMaterial(mat0);

        appears[1] = new Appearance();
        appears[1].setName("Appear ttt");
        Material mat1 = new Material();
        mat1.setName("Mat ttt");
        mat1.setAmbientColor(0.0f, 0.0f, 0.0f);
        mat1.setDiffuseColor(0.6f, 0.23921569f, 0.23921569f);
        mat1.setEmissiveColor(0.4f, 0.16078432f, 0.16078432f);
        mat1.setSpecularColor(0.0f, 0.0f, 0.0f);
        appears[1].setMaterial(mat1);
        
        appears[2] = new Appearance();
        appears[2].setName("Appear rrr");
        Material mat2 = new Material();
        mat2.setName("Mat rrr");
        mat2.setAmbientColor(0.0f, 0.0f, 0.0f);
        mat2.setDiffuseColor(0.0f, 0.36078432f, 0.6f);
        mat2.setEmissiveColor(0.0f, 0.23921569f, 0.4f);
        mat2.setSpecularColor(0.0f, 0.0f, 0.0f);
        appears[2].setMaterial(mat2);
        
        appears[3] = new Appearance();
        appears[3].setName("Appear iii");
        Material mat3 = new Material();
        mat3.setName("Mat iii");
        mat3.setAmbientColor(0.0f, 0.0f, 0.0f);
        mat3.setDiffuseColor(0.0f, 0.54901963f, 0.54901963f);
        mat3.setEmissiveColor(0.0f, 0.2509804f, 0.2509804f);
        mat3.setSpecularColor(0.0f, 0.0f, 0.0f);
        appears[3].setMaterial(mat3);
        
        appears[4] = new Appearance();
        appears[4].setName("Appear nnn");
        Material mat4 = new Material();
        mat4.setName("Mat nnn");
        mat4.setAmbientColor(0.0f, 0.0f, 0.0f);
        mat4.setDiffuseColor(0.36078432f, 0.6f, 0.0f);
        mat4.setEmissiveColor(0.23921569f, 0.4f, 0.0f);
        mat4.setSpecularColor(0.0f, 0.0f, 0.0f);
        appears[4].setMaterial(mat4);
        
        appears[5] = new Appearance();
        appears[5].setName("Appear ggg");
        Material mat5 = new Material();
        mat5.setName("Mat ggg");
        mat5.setAmbientColor(0.0f, 0.0f, 0.0f);
        mat5.setDiffuseColor(0.6509804f, 0.6509804f, 0.25882354f);
        mat5.setEmissiveColor(0.34901962f, 0.34901962f, 0.14117648f);
        mat5.setSpecularColor(0.0f, 0.0f, 0.0f);
        appears[5].setMaterial(mat5);

        // String3D
        
        GeneralPath extrPath = new GeneralPath();
        
        float extend = 2.0f; 
        float depth = 300.0f;
        float cut = depth/50.0f;
                
        extrPath.moveTo(0.0f, 0.0f);
        extrPath.lineTo(cut, extend);   
        extrPath.lineTo(depth-cut, extend);
        extrPath.lineTo(depth, 0.0f);

        AWTShapeExtrusion   extrusion   =   new AWTShapeExtrusion(extrPath); // or 300
        AWTShapeExtruder    extruder    =   new AWTShapeExtruder(0.15, extrusion, Math.toRadians(15));
        
        Font font = new Font("Dialog", Font.PLAIN, 100);
        
        String3D string3D = new String3D(font, extruder);
        
        // 3D
        string3D.setPosition(new Point3f(0, 0, 100));        
        string3D.setCharacterSpacing(0f);
        string3D.setAlignment(CENTER);
        string3D.setPath(RIGHT);

        GeometryArray geom3D = string3D.getStringGeometry("3D");
        
        Shape3D geom3DShape3D = new Shape3D();    
        geom3DShape3D.setAppearance(appear3d);
        geom3DShape3D.setGeometry(geom3D);
    
        sceneBranch.addChild(geom3DShape3D);
        
        // String fan
        string3D.setPosition(new Point3f(0, 0, 0));        
        string3D.setCharacterSpacing(5f);       
        string3D.setAlignment(LAST);                  
        string3D.setPath(DOWN_CENTER);
                       
        GeometryArray[] geoms = string3D.getCharacterGeometry("String   "); 
        
        addString3D(appears, geoms,  90);
        addString3D(appears, geoms,  60);
        addString3D(appears, geoms,  30);
        addString3D(appears, geoms,   0);
        addString3D(appears, geoms, -30);
        addString3D(appears, geoms, -60);
        addString3D(appears, geoms, -90);
        
    }
    
    private void addString3D(Appearance[] appears, GeometryArray[] geoms, double degrees) {
        
        TransformGroup tg = new TransformGroup();
        
        Transform3D t3d = new Transform3D();
        t3d.setRotation(new AxisAngle4d(0, 0, 1,  Math.toRadians(degrees)));
        
        tg.setTransform(t3d);        
        
        int k = 5;
        for (GeometryArray geom : geoms) {
            Shape3D shape3D = new Shape3D(geom, appears[k--]);            
            tg.addChild(shape3D);
        }       
        
        sceneBranch.addChild(tg);        
    }
    
    private void setLive() {
        sceneBranch.compile();
        viewBranch.compile();
        enviBranch.compile();
        locale.addBranchGraph(sceneBranch);
        locale.addBranchGraph(viewBranch);
        locale.addBranchGraph(enviBranch);
    }
    
    private void createUniverse() {     
        // Bounds
        globalBounds = new BoundingSphere();
        globalBounds.setRadius(Double.MAX_VALUE);       
        //
        // Viewing
        //
        View view = new View();
        view.setPhysicalBody(new PhysicalBody());
        view.setPhysicalEnvironment(new PhysicalEnvironment());
        
        GraphicsConfigTemplate3D gCT = new GraphicsConfigTemplate3D();
        GraphicsConfiguration gcfg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration(gCT);
        
        try {
            canvas3D = new Canvas3D(gcfg);
        }
        catch (NullPointerException e) {
            System.out.println("String3DFan: Canvas3D failed !!");
            e.printStackTrace();
            System.exit(0);
        }
        catch (IllegalArgumentException e) {
            System.out.println("String3DFan: Canvas3D failed !!");
            e.printStackTrace();
            System.exit(0);
        }               
        
        view.addCanvas3D(canvas3D);
        
        //
        // SuperStructure
        //
        VirtualUniverse vu = new VirtualUniverse();
        locale = new Locale(vu);        
        
        //
        // BranchGraphs
        //      
        sceneBranch = new BranchGroup();
        viewBranch = new BranchGroup();
        enviBranch = new BranchGroup();
        
        // ViewBranch
        
        TransformGroup viewTG = new TransformGroup();
        viewTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
                       
        ViewPlatform vp = new ViewPlatform();
        view.attachViewPlatform(vp);
        
        DirectionalLight headLight = new DirectionalLight();
        headLight.setInfluencingBounds(globalBounds);

        viewTG.addChild(vp);
        viewTG.addChild(headLight);
        
        viewBranch.addChild(viewTG);
        
        // Navigator
        orbitBehInterim = new OrbitBehaviorInterim(canvas3D, viewTG, view, OrbitBehaviorInterim.REVERSE_ALL);
        orbitBehInterim.setSchedulingBounds(globalBounds);
        orbitBehInterim.setClippingEnabled(true);
        Transform3D homeTransform = new Transform3D();
        homeTransform.lookAt(new Point3d(0, 560, 1828), new Point3d(0, 560 * (-0.15), 1828 * (-0.98)), new Vector3d(0, 1, 0));
        homeTransform.invert();
        orbitBehInterim.setHomeTransform(homeTransform);        
        orbitBehInterim.setHomeRotationCenter(new Point3d(0.0, 314.0, 200.0));

        viewTG.addChild(orbitBehInterim);       
        
        // EnviBranch
        
        Background bg = new Background();
        bg.setApplicationBounds(globalBounds);
        bg.setColor(0.2f, 0.4f, 1.0f);
        
        enviBranch.addChild(bg);
    }
}
