package com.interactivemesh.j3d.testspace.awtshape;

import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;

import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Locale;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;

import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;

import com.interactivemesh.j3d.community.utils.geometry.AWTShapeExtruder;
import com.interactivemesh.j3d.community.utils.geometry.String3D;

import com.interactivemesh.j3d.community.utils.navigation.orbit.OrbitBehaviorInterim;

/*
 * String3DOutline
 * 
 * Author: August Lammersdorf, www.InteractiveMesh.com/org
 * Version: 1.0
 * Date: 2008/12/02 
 * 
 * Please create your own implementation.
 * You are allowed to copy all lines you like of this source code, 
 * but you may not modify, compile, or distribute this 'String3DOutline'. 
 *
*/

final class String3DOutline {
    
    static {
        System.out.println("String3DOutline: Copyright (c) 2008 August Lammersdorf, www.InteractiveMesh.com.");
    }

    private BoundingSphere          globalBounds    =   null;

    private Canvas3D                canvas3D        =   null;
    private Locale                  locale          =   null;

    private BranchGroup             sceneBranch     =   null;
    private BranchGroup             viewBranch      =   null;
    private BranchGroup             enviBranch      =   null;

    private OrbitBehaviorInterim    orbitBehInterim =   null;
    
    String3DOutline() {

        createUniverse();
        createScene();
        setLive();

        // Setup navigation

        float sceneRadius = 1.0f;

        Bounds bounds = sceneBranch.getBounds();
        BoundingSphere sphereBounds = null; 

        if (bounds.isEmpty()) {
            sphereBounds = new BoundingSphere(); 
        }
        else {
            if (sphereBounds instanceof BoundingSphere)
                sphereBounds = (BoundingSphere)sceneBranch.getBounds();
            else
                sphereBounds = new BoundingSphere(sceneBranch.getBounds());

            sceneRadius = (float)sphereBounds.getRadius();
        }

        orbitBehInterim.setTransFactors(sceneRadius/2.0f, sceneRadius/2.0f);
        orbitBehInterim.setZoomFactor(sceneRadius/2.0f);
        orbitBehInterim.setRotFactors(0.75f, 0.75f);

        orbitBehInterim.setClippingBounds(sphereBounds);

        orbitBehInterim.goHome(true);
    }

    Canvas3D getCanvas3D() {
        return canvas3D;
    }

    private void createScene() {
        
        // Geometry
        
        AWTShapeExtruder extruder = new AWTShapeExtruder();
        extruder.setTessellationTolerance(0.001);
        
        String3D string3D = new String3D();
        string3D.setExtruder(extruder);

        // Airplane
        Font fontAirplane = new Font("Lucida Sans", Font.PLAIN, 100);
        
        string3D.setFont(fontAirplane);
        string3D.setAlignment(String3D.Alignment.CENTER);
        string3D.setPath(String3D.Path.UP_CENTER);
        string3D.setPosition(new Point3f(0f, 0f, 0f));        

        int[] codePointAirplane = new int[]{9992}; 
        String stringAirplane = new String(codePointAirplane, 0, 1);      
        
        GeometryArray geomAirplane   = string3D.getStringGeometry(stringAirplane);
        
        GeometryArray geomAirplaneOL = string3D.getStringOutlineGeometry(stringAirplane);

        // Smiley
        Font fontSmiley = new Font("Lucida Sans", Font.PLAIN, 10);
        
        string3D.setFont(fontSmiley);
        string3D.setPosition(new Point3f(35f, 0f, 0f));        
        
        int[] codePointSmiley = new int[]{9786}; 
        String stringSmiley = new String(codePointSmiley, 0, 1);      
        
        GeometryArray geomSmileyOL = string3D.getStringOutlineGeometry(stringSmiley);
        
        // OUT-LINE
        Font fontOutline = new Font("Dialog", Font.BOLD, 7);
        
        string3D.setFont(fontOutline);
        string3D.setCharacterSpacing(2);
        string3D.setPath(String3D.Path.RIGHT);
        string3D.setPosition(new Point3f(0f, 0f, 0f));  
        
        String stringOutline = new String("OUT-LINE");  
        
        BoundingBox bounds = new BoundingBox();
        
        GeometryArray geomOutline = string3D.getStringOutlineGeometry(stringOutline, bounds);
        
        // Center string at y=0 : -upperY + (upperY-lowerY)/2 = -0.5 * (lowerY + upperY)
        double lowerY = 0;
        double upperY = 0;
        Point3d p3d = new Point3d();
        bounds.getLower(p3d);
        lowerY = p3d.y;
        bounds.getUpper(p3d);
        upperY = p3d.y;
        
        TransformGroup tgOutline = new TransformGroup();
        Transform3D t3dOutline = new Transform3D();
        t3dOutline.setTranslation(new Vector3d(0, -0.5 * (lowerY + upperY), 0));
        tgOutline.setTransform(t3dOutline);
        
        
        // Appearance: Material, LineAttributes, PolygonAttributes
        
        Appearance appearAirplane = new Appearance();
        Material matAirplane = new Material();
        matAirplane.setAmbientColor(0.0f, 0.0f, 0.0f);
        matAirplane.setDiffuseColor(0.6f, 0.6f, 0.6f);
        matAirplane.setEmissiveColor(0.0f, 0.0f, 0.0f);
        matAirplane.setSpecularColor(0.2f, 0.2f, 0.2f);
        appearAirplane.setMaterial(matAirplane);
        
        PolygonAttributes polyAttrAirplane = new PolygonAttributes();
        polyAttrAirplane.setBackFaceNormalFlip(true);
        polyAttrAirplane.setCullFace(PolygonAttributes.CULL_NONE);
        polyAttrAirplane.setPolygonOffsetFactor(10);
        appearAirplane.setPolygonAttributes(polyAttrAirplane);
        

        Appearance appearAirplaneOL = new Appearance();
        Material matAirplaneOL = new Material();
        matAirplaneOL.setAmbientColor(0.0f, 0.0f, 0.0f);
        matAirplaneOL.setDiffuseColor(0.8f, 0.0f, 0.0f);
        matAirplaneOL.setEmissiveColor(0.2f, 0.0f, 0.0f);
        matAirplaneOL.setSpecularColor(0.0f, 0.0f, 0.0f);
        appearAirplaneOL.setMaterial(matAirplaneOL);
        
        LineAttributes linAttrAirplaneOL = new LineAttributes();
        linAttrAirplaneOL.setLineWidth(2);
        linAttrAirplaneOL.setLineAntialiasingEnable(true);
        appearAirplaneOL.setLineAttributes(linAttrAirplaneOL);


        Appearance appearSmileyOL = new Appearance();
        Material matSmileyOL = new Material();
        matSmileyOL.setAmbientColor(0.0f, 0.0f, 0.0f);
        matSmileyOL.setDiffuseColor(0.8f, 0.8f, 0.0f);
        matSmileyOL.setEmissiveColor(0.2f, 0.2f, 0.0f);
        matSmileyOL.setSpecularColor(0.0f, 0.0f, 0.0f);
        appearSmileyOL.setMaterial(matSmileyOL);

        
        Appearance appearOutline = new Appearance();
        Material matOutline = new Material();
        matOutline.setAmbientColor(0.0f, 0.0f, 0.0f);
        matOutline.setDiffuseColor(0.0f, 0.0f, 0.8f);
        matOutline.setEmissiveColor(0.0f, 0.0f, 0.2f);
        matOutline.setSpecularColor(0.0f, 0.0f, 0.0f);
        appearOutline.setMaterial(matOutline);
        
        LineAttributes linAttrOutline = new LineAttributes();
        linAttrOutline.setLineWidth(2);
        linAttrOutline.setLineAntialiasingEnable(true);
        appearOutline.setLineAttributes(linAttrOutline);
        
        // Shape3D
        
        Shape3D shapeAirplane = new Shape3D(geomAirplane, appearAirplane); 
        Shape3D shapeAirplaneOL = new Shape3D(geomAirplaneOL, appearAirplaneOL); 
        Shape3D shapeSmileyOL = new Shape3D(geomSmileyOL, appearSmileyOL); 
        Shape3D shapeOutline = new Shape3D(geomOutline, appearOutline); 
        
        sceneBranch.addChild(shapeAirplane);
        sceneBranch.addChild(shapeAirplaneOL);
        sceneBranch.addChild(shapeSmileyOL);
        
        tgOutline.addChild(shapeOutline);
        sceneBranch.addChild(tgOutline);

    }
    
    private void setLive() {
        sceneBranch.compile();
        viewBranch.compile();
        enviBranch.compile();
        locale.addBranchGraph(sceneBranch);
        locale.addBranchGraph(viewBranch);
        locale.addBranchGraph(enviBranch);
    }
    
    private void createUniverse() {     
        // Bounds
        globalBounds = new BoundingSphere();
        globalBounds.setRadius(Double.MAX_VALUE);       
        //
        // Viewing
        //
        View view = new View();
        view.setPhysicalBody(new PhysicalBody());
        view.setPhysicalEnvironment(new PhysicalEnvironment());
        
        GraphicsConfigTemplate3D gCT = new GraphicsConfigTemplate3D();
        GraphicsConfiguration gcfg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration(gCT);
        
        try {
            canvas3D = new Canvas3D(gcfg);
        }
        catch (NullPointerException e) {
            System.out.println("String3DOutline: Canvas3D failed !!");
            e.printStackTrace();
            System.exit(0);
        }
        catch (IllegalArgumentException e) {
            System.out.println("String3DOutline: Canvas3D failed !!");
            e.printStackTrace();
            System.exit(0);
        }               
        
        view.addCanvas3D(canvas3D);
        
        //
        // SuperStructure
        //
        VirtualUniverse vu = new VirtualUniverse();
        locale = new Locale(vu);        
        
        //
        // BranchGraphs
        //      
        sceneBranch = new BranchGroup();
        viewBranch = new BranchGroup();
        enviBranch = new BranchGroup();
        
        // ViewBranch
        
        TransformGroup viewTG = new TransformGroup();
        viewTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
                       
        ViewPlatform vp = new ViewPlatform();
        view.attachViewPlatform(vp);
        
        DirectionalLight headLight = new DirectionalLight();
        headLight.setInfluencingBounds(globalBounds);

        viewTG.addChild(vp);
        viewTG.addChild(headLight);
        
        viewBranch.addChild(viewTG);
        
        // Navigator
        orbitBehInterim = new OrbitBehaviorInterim(canvas3D, viewTG, view, OrbitBehaviorInterim.REVERSE_ALL);
        orbitBehInterim.setSchedulingBounds(globalBounds);
        orbitBehInterim.setClippingEnabled(true);
        Transform3D homeTransform = new Transform3D();
        homeTransform.lookAt(new Point3d(0, 0, 100), new Point3d(0, 0, 0), new Vector3d(0, 1, 0));
        homeTransform.invert();
        orbitBehInterim.setHomeTransform(homeTransform);        
        orbitBehInterim.setHomeRotationCenter(new Point3d(0.0, 0, 0));

        viewTG.addChild(orbitBehInterim);       
        
        // EnviBranch
        
        Background bg = new Background();
        bg.setApplicationBounds(globalBounds);
        bg.setColor(0.2f, 0.4f, 1.0f);
        
        enviBranch.addChild(bg);
    }
}
