/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Sound;
import javax.media.j3d.TransformGroup;
import org.jdesktop.j3d.loaders.vrml97.impl.BaseNode;
import org.jdesktop.j3d.loaders.vrml97.impl.Scene;
import org.jdesktop.j3d.loaders.vrml97.impl.TreeCleaner;
import org.jdesktop.j3d.loaders.vrml97.node.Background;
import org.jdesktop.j3d.loaders.vrml97.node.Fog;
import org.jdesktop.j3d.loaders.vrml97.node.Light;
import org.jdesktop.j3d.loaders.vrml97.node.Viewpoint;

public class VrmlScene
implements com.sun.j3d.loaders.Scene {
    Scene base;
    String description;
    int numTris;
    vrml.BaseNode[] objects;
    Viewpoint[] viewpoints;
    vrml.node.Node[] navInfos;
    Background[] backgrounds;
    Fog[] fogs;
    Light[] lights;
    Hashtable defTable;
    BranchGroup scene = null;

    VrmlScene(Scene base) {
        this.base = base;
        this.description = base.description;
        this.numTris = base.numTris;
        this.objects = new vrml.BaseNode[base.objects.size()];
        Enumeration<Object> elems = base.objects.elements();
        int i = 0;
        while (i < this.objects.length) {
            BaseNode node = (BaseNode)elems.nextElement();
            this.objects[i] = node.wrap();
            ++i;
        }
        this.viewpoints = new Viewpoint[base.viewpoints.size()];
        elems = base.viewpoints.elements();
        i = 0;
        while (i < this.viewpoints.length) {
            this.viewpoints[i] = (Viewpoint)((BaseNode)elems.nextElement()).wrap();
            ++i;
        }
        this.navInfos = new vrml.node.Node[base.navInfos.size()];
        elems = base.navInfos.elements();
        i = 0;
        while (i < this.navInfos.length) {
            this.navInfos[i] = (vrml.node.Node)((BaseNode)elems.nextElement()).wrap();
            ++i;
        }
        this.backgrounds = new Background[base.backgrounds.size()];
        elems = base.backgrounds.elements();
        i = 0;
        while (i < this.backgrounds.length) {
            this.backgrounds[i] = (Background)((BaseNode)elems.nextElement()).wrap();
            ++i;
        }
        this.fogs = new Fog[base.fogs.size()];
        elems = base.fogs.elements();
        i = 0;
        while (i < this.fogs.length) {
            this.fogs[i] = (Fog)((BaseNode)elems.nextElement()).wrap();
            ++i;
        }
        this.lights = new Light[base.lights.size()];
        elems = base.lights.elements();
        i = 0;
        while (i < this.lights.length) {
            this.lights[i] = (Light)((BaseNode)elems.nextElement()).wrap();
            ++i;
        }
        this.defTable = new Hashtable();
        elems = base.defTable.keys();
        while (elems.hasMoreElements()) {
            Object key = elems.nextElement();
            vrml.BaseNode value = ((BaseNode)base.defTable.get(key)).wrap();
            this.defTable.put(key, value);
        }
    }

    public BranchGroup getSceneGroup() {
        if (this.scene == null) {
            this.scene = new BranchGroup();
            int i = 0;
            while (i < this.objects.length) {
                Node j3dNode = this.objects[i].getImplNode();
                if (j3dNode != null) {
                    this.scene.addChild(j3dNode);
                }
                ++i;
            }
        }
        return this.scene;
    }

    public TransformGroup[] getViewGroups() {
        TransformGroup[] views = new TransformGroup[this.viewpoints.length];
        int i = 0;
        while (i < this.viewpoints.length) {
            views[i] = (TransformGroup)this.viewpoints[i].getImplNode();
            ++i;
        }
        return views;
    }

    public float[] getHorizontalFOVs() {
        float[] fovs = new float[this.viewpoints.length];
        int i = 0;
        while (i < this.viewpoints.length) {
            fovs[i] = this.viewpoints[i].getFOV();
            ++i;
        }
        return fovs;
    }

    public javax.media.j3d.Light[] getLightNodes() {
        javax.media.j3d.Light[] j3dLights = new javax.media.j3d.Light[this.lights.length * 2];
        int i = 0;
        while (i < this.lights.length) {
            j3dLights[i * 2] = this.lights[i].getAmbientLight();
            j3dLights[i * 2 + 1] = this.lights[i].getLight();
            ++i;
        }
        return j3dLights;
    }

    public Hashtable getNamedObjects() {
        Hashtable j3dDefTable = new Hashtable();
        Enumeration elems = this.defTable.keys();
        while (elems.hasMoreElements()) {
            Object key = elems.nextElement();
            vrml.BaseNode node = (vrml.BaseNode)this.defTable.get(key);
            Node value = node.getImplNode();
            if (value == null) continue;
            j3dDefTable.put(key, value);
        }
        return j3dDefTable;
    }

    public javax.media.j3d.Background[] getBackgroundNodes() {
        javax.media.j3d.Background[] j3dBackgrounds = new javax.media.j3d.Background[this.backgrounds.length];
        int i = 0;
        while (i < this.backgrounds.length) {
            j3dBackgrounds[i] = this.backgrounds[i].getBackgroundImpl();
            ++i;
        }
        return j3dBackgrounds;
    }

    public javax.media.j3d.Fog[] getFogNodes() {
        javax.media.j3d.Fog[] j3dFogs = new javax.media.j3d.Fog[this.fogs.length];
        int i = 0;
        while (i < this.fogs.length) {
            j3dFogs[i] = this.fogs[i].getFogImpl();
            ++i;
        }
        return j3dFogs;
    }

    public Behavior[] getBehaviorNodes() {
        return null;
    }

    public Sound[] getSoundNodes() {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void cleanForCompile(Node root) {
        TreeCleaner.cleanSubgraph(root);
    }

    public vrml.BaseNode[] getObjects() {
        vrml.BaseNode[] nodes = new vrml.BaseNode[this.objects.length];
        int i = 0;
        while (i < this.objects.length) {
            nodes[i] = this.objects[i];
            ++i;
        }
        return nodes;
    }

    public Viewpoint[] getViewpoints() {
        Viewpoint[] vps = new Viewpoint[this.viewpoints.length];
        int i = 0;
        while (i < this.viewpoints.length) {
            vps[i] = this.viewpoints[i];
            ++i;
        }
        return vps;
    }

    public Hashtable getDefineTable() {
        Hashtable userDefTable = new Hashtable();
        Enumeration elems = this.defTable.keys();
        while (elems.hasMoreElements()) {
            Object key = elems.nextElement();
            Object value = this.defTable.get(key);
            userDefTable.put(key, value);
        }
        return userDefTable;
    }

    public int getNumTris() {
        return this.numTris;
    }
}

